/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.RangedBeacon;

public class RangeState
implements Serializable {
    private static final String TAG = "RangeState";
    private Callback mCallback;
    private Map<Beacon, RangedBeacon> mRangedBeacons = new HashMap<Beacon, RangedBeacon>();
    private static boolean sUseTrackingCache = false;

    public RangeState(Callback c) {
        this.mCallback = c;
    }

    public Callback getCallback() {
        return this.mCallback;
    }

    public void addBeacon(Beacon beacon) {
        if (this.mRangedBeacons.containsKey(beacon)) {
            RangedBeacon rangedBeacon = this.mRangedBeacons.get(beacon);
            if (LogManager.isVerboseLoggingEnabled()) {
                LogManager.d(TAG, "adding %s to existing range for: %s", beacon, rangedBeacon);
            }
            rangedBeacon.updateBeacon(beacon);
        } else {
            if (LogManager.isVerboseLoggingEnabled()) {
                LogManager.d(TAG, "adding %s to new rangedBeacon", beacon);
            }
            this.mRangedBeacons.put(beacon, new RangedBeacon(beacon));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<Beacon> finalizeBeacons() {
        HashMap<Beacon, RangedBeacon> newRangedBeacons = new HashMap<Beacon, RangedBeacon>();
        ArrayList<Beacon> finalizedBeacons = new ArrayList<Beacon>();
        Map<Beacon, RangedBeacon> map = this.mRangedBeacons;
        synchronized (map) {
            for (Beacon beacon : this.mRangedBeacons.keySet()) {
                RangedBeacon rangedBeacon = this.mRangedBeacons.get(beacon);
                if (rangedBeacon.isTracked()) {
                    rangedBeacon.commitMeasurements();
                    if (!rangedBeacon.noMeasurementsAvailable()) {
                        finalizedBeacons.add(rangedBeacon.getBeacon());
                    }
                }
                if (!rangedBeacon.noMeasurementsAvailable()) {
                    if (!sUseTrackingCache || rangedBeacon.isExpired()) {
                        rangedBeacon.setTracked(false);
                    }
                    newRangedBeacons.put(beacon, rangedBeacon);
                    continue;
                }
                LogManager.d(TAG, "Dumping beacon from RangeState because it has no recent measurements.", new Object[0]);
            }
            this.mRangedBeacons = newRangedBeacons;
        }
        return finalizedBeacons;
    }

    public static void setUseTrackingCache(boolean useTrackingCache) {
        sUseTrackingCache = useTrackingCache;
    }

    public static boolean getUseTrackingCache() {
        return sUseTrackingCache;
    }
}

