/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.support.annotation.MainThread;
import android.support.annotation.RestrictTo;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.distance.ModelSpecificDistanceCalculator;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.ExtraDataBeaconTracker;
import org.altbeacon.beacon.service.MonitoringStatus;
import org.altbeacon.beacon.service.RangeState;
import org.altbeacon.beacon.service.ScanHelper;
import org.altbeacon.beacon.service.SettingsData;
import org.altbeacon.beacon.service.StartRMData;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.startup.StartupBroadcastReceiver;
import org.altbeacon.beacon.utils.ProcessUtils;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

public class BeaconService
extends Service {
    public static final String TAG = "BeaconService";
    private final Handler handler = new Handler();
    private BluetoothCrashResolver bluetoothCrashResolver;
    private ScanHelper mScanHelper;
    public static final int MSG_START_RANGING = 2;
    public static final int MSG_STOP_RANGING = 3;
    public static final int MSG_START_MONITORING = 4;
    public static final int MSG_STOP_MONITORING = 5;
    public static final int MSG_SET_SCAN_PERIODS = 6;
    public static final int MSG_SYNC_SETTINGS = 7;
    final Messenger mMessenger = new Messenger((Handler)new IncomingHandler(this));

    @MainThread
    public void onCreate() {
        this.bluetoothCrashResolver = new BluetoothCrashResolver((Context)this);
        this.bluetoothCrashResolver.start();
        this.mScanHelper = new ScanHelper((Context)this);
        if (this.mScanHelper.getCycledScanner() == null) {
            this.mScanHelper.createCycledLeScanner(false, this.bluetoothCrashResolver);
        }
        this.mScanHelper.setMonitoringStatus(MonitoringStatus.getInstanceForApplication((Context)this));
        this.mScanHelper.setRangedRegionState(new HashMap<Region, RangeState>());
        this.mScanHelper.setBeaconParsers(new HashSet<BeaconParser>());
        this.mScanHelper.setExtraDataBeaconTracker(new ExtraDataBeaconTracker());
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication(this.getApplicationContext());
        beaconManager.setScannerInSameProcess(true);
        if (beaconManager.isMainProcess()) {
            LogManager.i(TAG, "beaconService version %s is starting up on the main process", "2.12.3");
        } else {
            LogManager.i(TAG, "beaconService version %s is starting up on a separate process", "2.12.3");
            ProcessUtils processUtils = new ProcessUtils((Context)this);
            LogManager.i(TAG, "beaconService PID is " + processUtils.getPid() + " with process name " + processUtils.getProcessName(), new Object[0]);
        }
        try {
            ServiceInfo info = this.getPackageManager().getServiceInfo(new ComponentName((Context)this, BeaconService.class), 128);
            if (info != null && info.metaData != null && info.metaData.get("longScanForcingEnabled") != null && info.metaData.get("longScanForcingEnabled").toString().equals("true")) {
                LogManager.i(TAG, "longScanForcingEnabled to keep scans going on Android N for > 30 minutes", new Object[0]);
                this.mScanHelper.getCycledScanner().setLongScanForcingEnabled(true);
            }
        }
        catch (PackageManager.NameNotFoundException info) {
            // empty catch block
        }
        this.mScanHelper.reloadParsers();
        ModelSpecificDistanceCalculator defaultDistanceCalculator = new ModelSpecificDistanceCalculator((Context)this, BeaconManager.getDistanceModelUpdateUrl());
        Beacon.setDistanceCalculator(defaultDistanceCalculator);
        try {
            Class<?> klass = Class.forName("org.altbeacon.beacon.SimulatedScanData");
            Field f = klass.getField("beacons");
            this.mScanHelper.setSimulatedScanData((List)f.get(null));
        }
        catch (ClassNotFoundException e) {
            LogManager.d(TAG, "No org.altbeacon.beacon.SimulatedScanData class exists.", new Object[0]);
        }
        catch (Exception e) {
            LogManager.e(e, TAG, "Cannot get simulated Scan data.  Make sure your org.altbeacon.beacon.SimulatedScanData class defines a field with the signature 'public static List<Beacon> beacons'", new Object[0]);
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        LogManager.i(TAG, intent == null ? "starting with null intent" : "starting with intent " + intent.toString(), new Object[0]);
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent intent) {
        LogManager.i(TAG, "binding", new Object[0]);
        return this.mMessenger.getBinder();
    }

    public boolean onUnbind(Intent intent) {
        LogManager.i(TAG, "unbinding", new Object[0]);
        return false;
    }

    @MainThread
    public void onDestroy() {
        LogManager.e(TAG, "onDestroy()", new Object[0]);
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.", new Object[0]);
            return;
        }
        this.bluetoothCrashResolver.stop();
        LogManager.i(TAG, "onDestroy called.  stopping scanning", new Object[0]);
        this.handler.removeCallbacksAndMessages(null);
        this.mScanHelper.getCycledScanner().stop();
        this.mScanHelper.getCycledScanner().destroy();
        this.mScanHelper.getMonitoringStatus().stopStatusPreservation();
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        LogManager.d(TAG, "task removed", new Object[0]);
        if (Build.VERSION.RELEASE.contains("4.4.1") || Build.VERSION.RELEASE.contains("4.4.2") || Build.VERSION.RELEASE.contains("4.4.3")) {
            AlarmManager alarmManager = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
            alarmManager.set(0, System.currentTimeMillis() + 1000L, this.getRestartIntent());
            LogManager.d(TAG, "Setting a wakeup alarm to go off due to Android 4.4.2 service restarting bug.", new Object[0]);
        }
    }

    private PendingIntent getRestartIntent() {
        Intent restartIntent = new Intent(this.getApplicationContext(), StartupBroadcastReceiver.class);
        return PendingIntent.getBroadcast((Context)this.getApplicationContext(), (int)1, (Intent)restartIntent, (int)0x40000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public void startRangingBeaconsInRegion(Region region, Callback callback) {
        Map<Region, RangeState> map = this.mScanHelper.getRangedRegionState();
        synchronized (map) {
            if (this.mScanHelper.getRangedRegionState().containsKey(region)) {
                LogManager.i(TAG, "Already ranging that region -- will replace existing region.", new Object[0]);
                this.mScanHelper.getRangedRegionState().remove(region);
            }
            this.mScanHelper.getRangedRegionState().put(region, new RangeState(callback));
            LogManager.d(TAG, "Currently ranging %s regions.", this.mScanHelper.getRangedRegionState().size());
        }
        this.mScanHelper.getCycledScanner().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public void stopRangingBeaconsInRegion(Region region) {
        int rangedRegionCount;
        Map<Region, RangeState> map = this.mScanHelper.getRangedRegionState();
        synchronized (map) {
            this.mScanHelper.getRangedRegionState().remove(region);
            rangedRegionCount = this.mScanHelper.getRangedRegionState().size();
            LogManager.d(TAG, "Currently ranging %s regions.", this.mScanHelper.getRangedRegionState().size());
        }
        if (rangedRegionCount == 0 && this.mScanHelper.getMonitoringStatus().regionsCount() == 0) {
            this.mScanHelper.getCycledScanner().stop();
        }
    }

    @MainThread
    public void startMonitoringBeaconsInRegion(Region region, Callback callback) {
        LogManager.d(TAG, "startMonitoring called", new Object[0]);
        this.mScanHelper.getMonitoringStatus().addRegion(region, callback);
        LogManager.d(TAG, "Currently monitoring %s regions.", this.mScanHelper.getMonitoringStatus().regionsCount());
        this.mScanHelper.getCycledScanner().start();
    }

    @MainThread
    public void stopMonitoringBeaconsInRegion(Region region) {
        LogManager.d(TAG, "stopMonitoring called", new Object[0]);
        this.mScanHelper.getMonitoringStatus().removeRegion(region);
        LogManager.d(TAG, "Currently monitoring %s regions.", this.mScanHelper.getMonitoringStatus().regionsCount());
        if (this.mScanHelper.getMonitoringStatus().regionsCount() == 0 && this.mScanHelper.getRangedRegionState().size() == 0) {
            this.mScanHelper.getCycledScanner().stop();
        }
    }

    @MainThread
    public void setScanPeriods(long scanPeriod, long betweenScanPeriod, boolean backgroundFlag) {
        this.mScanHelper.getCycledScanner().setScanPeriods(scanPeriod, betweenScanPeriod, backgroundFlag);
    }

    public void reloadParsers() {
        this.mScanHelper.reloadParsers();
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    protected CycledLeScanCallback getCycledLeScanCallback() {
        return this.mScanHelper.getCycledLeScanCallback();
    }

    static class IncomingHandler
    extends Handler {
        private final WeakReference<BeaconService> mService;

        IncomingHandler(BeaconService service) {
            super(Looper.getMainLooper());
            this.mService = new WeakReference<BeaconService>(service);
        }

        @MainThread
        public void handleMessage(Message msg) {
            BeaconService service = (BeaconService)((Object)this.mService.get());
            if (service != null) {
                StartRMData startRMData = StartRMData.fromBundle(msg.getData());
                if (startRMData != null) {
                    switch (msg.what) {
                        case 2: {
                            LogManager.i(BeaconService.TAG, "start ranging received", new Object[0]);
                            service.startRangingBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        case 3: {
                            LogManager.i(BeaconService.TAG, "stop ranging received", new Object[0]);
                            service.stopRangingBeaconsInRegion(startRMData.getRegionData());
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        case 4: {
                            LogManager.i(BeaconService.TAG, "start monitoring received", new Object[0]);
                            service.startMonitoringBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        case 5: {
                            LogManager.i(BeaconService.TAG, "stop monitoring received", new Object[0]);
                            service.stopMonitoringBeaconsInRegion(startRMData.getRegionData());
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        case 6: {
                            LogManager.i(BeaconService.TAG, "set scan intervals received", new Object[0]);
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        default: {
                            super.handleMessage(msg);
                            break;
                        }
                    }
                } else if (msg.what == 7) {
                    LogManager.i(BeaconService.TAG, "Received settings update from other process", new Object[0]);
                    SettingsData settingsData = SettingsData.fromBundle(msg.getData());
                    if (settingsData != null) {
                        settingsData.apply(service);
                    } else {
                        LogManager.w(BeaconService.TAG, "Settings data missing", new Object[0]);
                    }
                } else {
                    LogManager.i(BeaconService.TAG, "Received unknown message from other process : " + msg.what, new Object[0]);
                }
            }
        }
    }

    public class BeaconBinder
    extends Binder {
        public BeaconService getService() {
            LogManager.i(BeaconService.TAG, "getService of BeaconBinder called", new Object[0]);
            return BeaconService.this;
        }
    }
}

