/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.altbeacon.beacon.AltBeaconParser;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.BleNotAvailableException;
import org.altbeacon.beacon.MonitorNotifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.logging.Loggers;
import org.altbeacon.beacon.service.BeaconService;
import org.altbeacon.beacon.service.MonitoringStatus;
import org.altbeacon.beacon.service.RangeState;
import org.altbeacon.beacon.service.RangedBeacon;
import org.altbeacon.beacon.service.RegionMonitoringState;
import org.altbeacon.beacon.service.RunningAverageRssiFilter;
import org.altbeacon.beacon.service.SettingsData;
import org.altbeacon.beacon.service.StartRMData;
import org.altbeacon.beacon.service.scanner.NonBeaconLeScanCallback;
import org.altbeacon.beacon.simulator.BeaconSimulator;
import org.altbeacon.beacon.utils.ProcessUtils;

public class BeaconManager {
    @NonNull
    private static final String TAG = "BeaconManager";
    @NonNull
    private final Context mContext;
    @Nullable
    protected static volatile BeaconManager sInstance = null;
    @NonNull
    private final ConcurrentMap<BeaconConsumer, ConsumerInfo> consumers = new ConcurrentHashMap<BeaconConsumer, ConsumerInfo>();
    @Nullable
    private Messenger serviceMessenger = null;
    @NonNull
    protected final Set<RangeNotifier> rangeNotifiers = new CopyOnWriteArraySet<RangeNotifier>();
    @Nullable
    protected RangeNotifier dataRequestNotifier = null;
    @NonNull
    protected final Set<MonitorNotifier> monitorNotifiers = new CopyOnWriteArraySet<MonitorNotifier>();
    @NonNull
    private final ArrayList<Region> rangedRegions = new ArrayList();
    @NonNull
    private final List<BeaconParser> beaconParsers = new CopyOnWriteArrayList<BeaconParser>();
    @Nullable
    private NonBeaconLeScanCallback mNonBeaconLeScanCallback;
    private boolean mRegionStatePersistenceEnabled = true;
    private boolean mBackgroundMode = false;
    private boolean mBackgroundModeUninitialized = true;
    private boolean mMainProcess = false;
    @Nullable
    private Boolean mScannerInSameProcess = null;
    private static boolean sAndroidLScanningDisabled = false;
    private static boolean sManifestCheckingDisabled = false;
    private static final Object SINGLETON_LOCK = new Object();
    public static final long DEFAULT_FOREGROUND_SCAN_PERIOD = 1100L;
    public static final long DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD = 0L;
    public static final long DEFAULT_BACKGROUND_SCAN_PERIOD = 10000L;
    public static final long DEFAULT_BACKGROUND_BETWEEN_SCAN_PERIOD = 300000L;
    public static final long DEFAULT_EXIT_PERIOD = 10000L;
    private static long sExitRegionPeriod = 10000L;
    private long foregroundScanPeriod = 1100L;
    private long foregroundBetweenScanPeriod = 0L;
    private long backgroundScanPeriod = 10000L;
    private long backgroundBetweenScanPeriod = 300000L;
    @Nullable
    protected static BeaconSimulator beaconSimulator;
    protected static String distanceModelUpdateUrl;
    protected static Class rssiFilterImplClass;

    @Deprecated
    public static void setDebug(boolean debug) {
        if (debug) {
            LogManager.setLogger(Loggers.verboseLogger());
            LogManager.setVerboseLoggingEnabled(true);
        } else {
            LogManager.setLogger(Loggers.empty());
            LogManager.setVerboseLoggingEnabled(false);
        }
    }

    public void setForegroundScanPeriod(long p) {
        this.foregroundScanPeriod = p;
    }

    public void setForegroundBetweenScanPeriod(long p) {
        this.foregroundBetweenScanPeriod = p;
    }

    public void setBackgroundScanPeriod(long p) {
        this.backgroundScanPeriod = p;
    }

    public void setBackgroundBetweenScanPeriod(long p) {
        this.backgroundBetweenScanPeriod = p;
    }

    public static void setRegionExitPeriod(long regionExitPeriod) {
        sExitRegionPeriod = regionExitPeriod;
        BeaconManager instance = sInstance;
        if (instance != null) {
            instance.applySettings();
        }
    }

    public static long getRegionExitPeriod() {
        return sExitRegionPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static BeaconManager getInstanceForApplication(@NonNull Context context) {
        BeaconManager instance = sInstance;
        if (instance == null) {
            Object object = SINGLETON_LOCK;
            synchronized (object) {
                instance = sInstance;
                if (instance == null) {
                    sInstance = instance = new BeaconManager(context);
                }
            }
        }
        return instance;
    }

    protected BeaconManager(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.checkIfMainProcess();
        if (!sManifestCheckingDisabled) {
            this.verifyServiceDeclaration();
        }
        this.beaconParsers.add(new AltBeaconParser());
    }

    public boolean isMainProcess() {
        return this.mMainProcess;
    }

    public boolean isScannerInDifferentProcess() {
        return this.mScannerInSameProcess != null && this.mScannerInSameProcess == false;
    }

    public void setScannerInSameProcess(boolean isScanner) {
        this.mScannerInSameProcess = isScanner;
    }

    protected void checkIfMainProcess() {
        ProcessUtils processUtils = new ProcessUtils(this.mContext);
        String processName = processUtils.getProcessName();
        String packageName = processUtils.getPackageName();
        int pid = processUtils.getPid();
        this.mMainProcess = processUtils.isMainProcess();
        LogManager.i(TAG, "BeaconManager started up on pid " + pid + " named '" + processName + "' for application package '" + packageName + "'.  isMainProcess=" + this.mMainProcess, new Object[0]);
    }

    @NonNull
    public List<BeaconParser> getBeaconParsers() {
        return this.beaconParsers;
    }

    @TargetApi(value=18)
    public boolean checkAvailability() throws BleNotAvailableException {
        if (!this.isBleAvailable()) {
            throw new BleNotAvailableException("Bluetooth LE not supported by this device");
        }
        return ((BluetoothManager)this.mContext.getSystemService("bluetooth")).getAdapter().isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(@NonNull BeaconConsumer consumer) {
        if (!this.isBleAvailable()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            LogManager.w(TAG, "This device does not support bluetooth LE.  Will not start beacon scanning.", new Object[0]);
            return;
        }
        ConcurrentMap<BeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            ConsumerInfo newConsumerInfo = new ConsumerInfo();
            ConsumerInfo alreadyBoundConsumerInfo = this.consumers.putIfAbsent(consumer, newConsumerInfo);
            if (alreadyBoundConsumerInfo != null) {
                LogManager.d(TAG, "This consumer is already bound", new Object[0]);
            } else {
                LogManager.d(TAG, "This consumer is not bound.  binding: %s", consumer);
                Intent intent = new Intent(consumer.getApplicationContext(), BeaconService.class);
                consumer.bindService(intent, newConsumerInfo.beaconServiceConnection, 1);
                LogManager.d(TAG, "consumer count is now: %s", this.consumers.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(@NonNull BeaconConsumer consumer) {
        if (!this.isBleAvailable()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        ConcurrentMap<BeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            if (this.consumers.containsKey(consumer)) {
                LogManager.d(TAG, "Unbinding", new Object[0]);
                consumer.unbindService(((ConsumerInfo)this.consumers.get((Object)consumer)).beaconServiceConnection);
                this.consumers.remove(consumer);
                if (this.consumers.size() == 0) {
                    this.serviceMessenger = null;
                    this.mBackgroundMode = false;
                }
            } else {
                LogManager.d(TAG, "This consumer is not bound to: %s", consumer);
                LogManager.d(TAG, "Bound consumers: ", new Object[0]);
                Set consumers = this.consumers.entrySet();
                for (Map.Entry consumerEntry : consumers) {
                    LogManager.d(TAG, String.valueOf(consumerEntry.getValue()), new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound(@NonNull BeaconConsumer consumer) {
        ConcurrentMap<BeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            return consumer != null && this.consumers.get(consumer) != null && this.serviceMessenger != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnyConsumerBound() {
        ConcurrentMap<BeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            return this.consumers.isEmpty() && this.serviceMessenger != null;
        }
    }

    public void setBackgroundMode(boolean backgroundMode) {
        if (!this.isBleAvailable()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        this.mBackgroundModeUninitialized = false;
        if (backgroundMode != this.mBackgroundMode) {
            this.mBackgroundMode = backgroundMode;
            try {
                this.updateScanPeriods();
            }
            catch (RemoteException e) {
                LogManager.e(TAG, "Cannot contact service to set scan periods", new Object[0]);
            }
        }
    }

    public boolean isBackgroundModeUninitialized() {
        return this.mBackgroundModeUninitialized;
    }

    @Deprecated
    public void setRangeNotifier(@Nullable RangeNotifier notifier) {
        this.rangeNotifiers.clear();
        if (null != notifier) {
            this.addRangeNotifier(notifier);
        }
    }

    public void addRangeNotifier(@NonNull RangeNotifier notifier) {
        if (notifier != null) {
            this.rangeNotifiers.add(notifier);
        }
    }

    public boolean removeRangeNotifier(@NonNull RangeNotifier notifier) {
        return this.rangeNotifiers.remove(notifier);
    }

    public void removeAllRangeNotifiers() {
        this.rangeNotifiers.clear();
    }

    @Deprecated
    public void setMonitorNotifier(@Nullable MonitorNotifier notifier) {
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        this.monitorNotifiers.clear();
        if (null != notifier) {
            this.addMonitorNotifier(notifier);
        }
    }

    public void addMonitorNotifier(@NonNull MonitorNotifier notifier) {
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (notifier != null) {
            this.monitorNotifiers.add(notifier);
        }
    }

    @Deprecated
    public boolean removeMonitoreNotifier(@NonNull MonitorNotifier notifier) {
        return this.removeMonitorNotifier(notifier);
    }

    public boolean removeMonitorNotifier(@NonNull MonitorNotifier notifier) {
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return false;
        }
        return this.monitorNotifiers.remove(notifier);
    }

    public void removeAllMonitorNotifiers() {
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        this.monitorNotifiers.clear();
    }

    @Deprecated
    public void setRegionStatePeristenceEnabled(boolean enabled) {
        this.setRegionStatePersistenceEnabled(enabled);
    }

    public void setRegionStatePersistenceEnabled(boolean enabled) {
        this.mRegionStatePersistenceEnabled = enabled;
        if (!this.isScannerInDifferentProcess()) {
            if (enabled) {
                MonitoringStatus.getInstanceForApplication(this.mContext).startStatusPreservation();
            } else {
                MonitoringStatus.getInstanceForApplication(this.mContext).stopStatusPreservation();
            }
        }
        this.applySettings();
    }

    public boolean isRegionStatePersistenceEnabled() {
        return this.mRegionStatePersistenceEnabled;
    }

    public void requestStateForRegion(@NonNull Region region) {
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        MonitoringStatus status = MonitoringStatus.getInstanceForApplication(this.mContext);
        RegionMonitoringState stateObj = status.stateOf(region);
        int state = 0;
        if (stateObj != null && stateObj.getInside()) {
            state = 1;
        }
        for (MonitorNotifier notifier : this.monitorNotifiers) {
            notifier.didDetermineStateForRegion(state, region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void startRangingBeaconsInRegion(@NonNull Region region) throws RemoteException {
        if (!this.isBleAvailable()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)2, (int)0, (int)0);
        msg.setData(new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode).toBundle());
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            this.rangedRegions.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void stopRangingBeaconsInRegion(@NonNull Region region) throws RemoteException {
        if (!this.isBleAvailable()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)3, (int)0, (int)0);
        msg.setData(new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode).toBundle());
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            Region regionToRemove = null;
            for (Region rangedRegion : this.rangedRegions) {
                if (!region.getUniqueId().equals(rangedRegion.getUniqueId())) continue;
                regionToRemove = rangedRegion;
            }
            this.rangedRegions.remove(regionToRemove);
        }
    }

    public void applySettings() {
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (!this.isAnyConsumerBound()) {
            LogManager.d(TAG, "Not synchronizing settings to service, as it has not started up yet", new Object[0]);
        } else if (this.isScannerInDifferentProcess()) {
            LogManager.d(TAG, "Synchronizing settings to service", new Object[0]);
            this.syncSettingsToService();
        } else {
            LogManager.d(TAG, "Not synchronizing settings to service, as it is in the same process", new Object[0]);
        }
    }

    protected void syncSettingsToService() {
        if (this.serviceMessenger == null) {
            LogManager.e(TAG, "The BeaconManager is not bound to the service.  Settings synchronization will fail.", new Object[0]);
            return;
        }
        try {
            Message msg = Message.obtain(null, (int)7, (int)0, (int)0);
            msg.setData(new SettingsData().collect(this.mContext).toBundle());
            this.serviceMessenger.send(msg);
        }
        catch (RemoteException e) {
            LogManager.e(e, TAG, "Failed to sync settings to service", new Object[0]);
        }
    }

    @TargetApi(value=18)
    public void startMonitoringBeaconsInRegion(@NonNull Region region) throws RemoteException {
        if (!this.isBleAvailable()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        LogManager.d(TAG, "Starting monitoring region " + region + " with uniqueID: " + region.getUniqueId(), new Object[0]);
        Message msg = Message.obtain(null, (int)4, (int)0, (int)0);
        msg.setData(new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode).toBundle());
        this.serviceMessenger.send(msg);
        if (this.isScannerInDifferentProcess()) {
            MonitoringStatus.getInstanceForApplication(this.mContext).addLocalRegion(region);
        }
        this.requestStateForRegion(region);
    }

    @TargetApi(value=18)
    public void stopMonitoringBeaconsInRegion(@NonNull Region region) throws RemoteException {
        if (!this.isBleAvailable()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)5, (int)0, (int)0);
        msg.setData(new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode).toBundle());
        this.serviceMessenger.send(msg);
        if (this.isScannerInDifferentProcess()) {
            MonitoringStatus.getInstanceForApplication(this.mContext).removeLocalRegion(region);
        }
    }

    @TargetApi(value=18)
    public void updateScanPeriods() throws RemoteException {
        if (!this.isBleAvailable()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)6, (int)0, (int)0);
        LogManager.d(TAG, "updating background flag to %s", this.mBackgroundMode);
        LogManager.d(TAG, "updating scan period to %s, %s", this.getScanPeriod(), this.getBetweenScanPeriod());
        msg.setData(new StartRMData(this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode).toBundle());
        this.serviceMessenger.send(msg);
    }

    private String callbackPackageName() {
        String packageName = this.mContext.getPackageName();
        LogManager.d(TAG, "callback packageName: %s", packageName);
        return packageName;
    }

    @Deprecated
    @Nullable
    public MonitorNotifier getMonitoringNotifier() {
        Iterator<MonitorNotifier> iterator = this.monitorNotifiers.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @NonNull
    public Set<MonitorNotifier> getMonitoringNotifiers() {
        return Collections.unmodifiableSet(this.monitorNotifiers);
    }

    @Deprecated
    @Nullable
    public RangeNotifier getRangingNotifier() {
        Iterator<RangeNotifier> iterator = this.rangeNotifiers.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @NonNull
    public Set<RangeNotifier> getRangingNotifiers() {
        return Collections.unmodifiableSet(this.rangeNotifiers);
    }

    @NonNull
    public Collection<Region> getMonitoredRegions() {
        return MonitoringStatus.getInstanceForApplication(this.mContext).regions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Collection<Region> getRangedRegions() {
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            return new ArrayList<Region>(this.rangedRegions);
        }
    }

    @Deprecated
    public static void logDebug(String tag, String message) {
        LogManager.d(tag, message, new Object[0]);
    }

    @Deprecated
    public static void logDebug(String tag, String message, Throwable t) {
        LogManager.d(t, tag, message, new Object[0]);
    }

    public static String getDistanceModelUpdateUrl() {
        return distanceModelUpdateUrl;
    }

    public static void setDistanceModelUpdateUrl(@NonNull String url) {
        BeaconManager.warnIfScannerNotInSameProcess();
        distanceModelUpdateUrl = url;
    }

    public static void setRssiFilterImplClass(@NonNull Class c) {
        BeaconManager.warnIfScannerNotInSameProcess();
        rssiFilterImplClass = c;
    }

    public static Class getRssiFilterImplClass() {
        return rssiFilterImplClass;
    }

    public static void setUseTrackingCache(boolean useTrackingCache) {
        RangeState.setUseTrackingCache(useTrackingCache);
        if (sInstance != null) {
            sInstance.applySettings();
        }
    }

    public void setMaxTrackingAge(int maxTrackingAge) {
        RangedBeacon.setMaxTrackinAge(maxTrackingAge);
    }

    public static void setBeaconSimulator(BeaconSimulator beaconSimulator) {
        BeaconManager.warnIfScannerNotInSameProcess();
        BeaconManager.beaconSimulator = beaconSimulator;
    }

    @Nullable
    public static BeaconSimulator getBeaconSimulator() {
        return beaconSimulator;
    }

    protected void setDataRequestNotifier(@Nullable RangeNotifier notifier) {
        this.dataRequestNotifier = notifier;
    }

    @Nullable
    protected RangeNotifier getDataRequestNotifier() {
        return this.dataRequestNotifier;
    }

    @Nullable
    public NonBeaconLeScanCallback getNonBeaconLeScanCallback() {
        return this.mNonBeaconLeScanCallback;
    }

    public void setNonBeaconLeScanCallback(@Nullable NonBeaconLeScanCallback callback) {
        this.mNonBeaconLeScanCallback = callback;
    }

    private boolean isBleAvailable() {
        boolean available = false;
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Bluetooth LE not supported prior to API 18.", new Object[0]);
        } else if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            LogManager.w(TAG, "This device does not support bluetooth LE.", new Object[0]);
        } else {
            available = true;
        }
        return available;
    }

    private long getScanPeriod() {
        if (this.mBackgroundMode) {
            return this.backgroundScanPeriod;
        }
        return this.foregroundScanPeriod;
    }

    private long getBetweenScanPeriod() {
        if (this.mBackgroundMode) {
            return this.backgroundBetweenScanPeriod;
        }
        return this.foregroundBetweenScanPeriod;
    }

    private void verifyServiceDeclaration() {
        Intent intent;
        PackageManager packageManager = this.mContext.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent(this.mContext, BeaconService.class), 65536);
        if (resolveInfo != null && resolveInfo.size() == 0) {
            throw new ServiceNotDeclaredException();
        }
    }

    public static boolean isAndroidLScanningDisabled() {
        return sAndroidLScanningDisabled;
    }

    public static void setAndroidLScanningDisabled(boolean disabled) {
        sAndroidLScanningDisabled = disabled;
        BeaconManager instance = sInstance;
        if (instance != null) {
            instance.applySettings();
        }
    }

    @Deprecated
    public static void setsManifestCheckingDisabled(boolean disabled) {
        sManifestCheckingDisabled = disabled;
    }

    public static void setManifestCheckingDisabled(boolean disabled) {
        sManifestCheckingDisabled = disabled;
    }

    public static boolean getManifestCheckingDisabled() {
        return sManifestCheckingDisabled;
    }

    private boolean determineIfCalledFromSeparateScannerProcess() {
        if (this.isScannerInDifferentProcess() && !this.isMainProcess()) {
            LogManager.w(TAG, "Ranging/Monitoring may not be controlled from a separate BeaconScanner process.  To remove this warning, please wrap this call in: if (beaconManager.isMainProcess())", new Object[0]);
            return true;
        }
        return false;
    }

    private static void warnIfScannerNotInSameProcess() {
        BeaconManager instance = sInstance;
        if (instance != null && instance.isScannerInDifferentProcess()) {
            LogManager.w(TAG, "Unsupported configuration change made for BeaconScanner in separate process", new Object[0]);
        }
    }

    static {
        distanceModelUpdateUrl = "http://data.altbeacon.org/android-distance.json";
        rssiFilterImplClass = RunningAverageRssiFilter.class;
    }

    public class ServiceNotDeclaredException
    extends RuntimeException {
        public ServiceNotDeclaredException() {
            super("The BeaconService is not properly declared in AndroidManifest.xml.  If using Eclipse, please verify that your project.properties has manifestmerger.enabled=true");
        }
    }

    private class BeaconServiceConnection
    implements ServiceConnection {
        private BeaconServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            LogManager.d(BeaconManager.TAG, "we have a connection to the service now", new Object[0]);
            if (BeaconManager.this.mScannerInSameProcess == null) {
                BeaconManager.this.mScannerInSameProcess = false;
            }
            BeaconManager.this.serviceMessenger = new Messenger(service);
            BeaconManager.this.applySettings();
            ConcurrentMap concurrentMap = BeaconManager.this.consumers;
            synchronized (concurrentMap) {
                for (Map.Entry entry : BeaconManager.this.consumers.entrySet()) {
                    if (((ConsumerInfo)entry.getValue()).isConnected) continue;
                    ((BeaconConsumer)entry.getKey()).onBeaconServiceConnect();
                    ((ConsumerInfo)entry.getValue()).isConnected = true;
                }
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            LogManager.e(BeaconManager.TAG, "onServiceDisconnected", new Object[0]);
            BeaconManager.this.serviceMessenger = null;
        }
    }

    private class ConsumerInfo {
        public boolean isConnected = false;
        @NonNull
        public BeaconServiceConnection beaconServiceConnection;

        public ConsumerInfo() {
            this.beaconServiceConnection = new BeaconServiceConnection();
        }
    }
}

