/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public class DistinctPacketDetector {
    private static final int MAX_PACKETS_TO_TRACK = 1000;
    protected Set<ByteBuffer> mDistinctPacketsDetected = new HashSet<ByteBuffer>();

    public void clearDetections() {
        this.mDistinctPacketsDetected.clear();
    }

    public boolean isPacketDistinct(String originMacAddress, byte[] scanRecord) {
        boolean distinct;
        byte[] macBytes = originMacAddress.getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(macBytes.length + scanRecord.length);
        buffer.put(macBytes);
        buffer.put(scanRecord);
        buffer.rewind();
        boolean bl = distinct = !this.mDistinctPacketsDetected.contains(buffer);
        if (this.mDistinctPacketsDetected.size() == 1000) {
            return this.mDistinctPacketsDetected.contains(buffer);
        }
        return this.mDistinctPacketsDetected.add(buffer);
    }
}

