/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import android.annotation.TargetApi;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.service.DetectionTracker;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScanner;
import org.altbeacon.beacon.service.scanner.ScanFilterUtils;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

@TargetApi(value=21)
public class CycledLeScannerForLollipop
extends CycledLeScanner {
    private static final String TAG = "CycledLeScannerForLollipop";
    private static final long BACKGROUND_L_SCAN_DETECTION_PERIOD_MILLIS = 10000L;
    private BluetoothLeScanner mScanner;
    private ScanCallback leScanCallback;
    private long mBackgroundLScanStartTime = 0L;
    private long mBackgroundLScanFirstDetectionTime = 0L;
    private boolean mScanDeferredBefore = false;
    private BeaconManager mBeaconManager = BeaconManager.getInstanceForApplication(this.mContext);

    public CycledLeScannerForLollipop(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, CycledLeScanCallback cycledLeScanCallback, BluetoothCrashResolver crashResolver) {
        super(context, scanPeriod, betweenScanPeriod, backgroundFlag, cycledLeScanCallback, crashResolver);
    }

    @Override
    protected void stopScan() {
        try {
            this.mScanner.stopScan(this.getNewLeScanCallback());
        }
        catch (Exception e) {
            Log.w((String)"Internal Android exception scanning for beacons: ", (Throwable)e);
        }
    }

    @Override
    protected boolean deferScanIfNeeded() {
        long millisecondsUntilStart = this.mNextScanCycleStartTime - System.currentTimeMillis();
        if (millisecondsUntilStart > 0L) {
            long secsSinceLastDetection = System.currentTimeMillis() - DetectionTracker.getInstance().getLastDetectionTime();
            if (!this.mScanDeferredBefore) {
                if (secsSinceLastDetection > 10000L) {
                    this.mBackgroundLScanStartTime = System.currentTimeMillis();
                    this.mBackgroundLScanFirstDetectionTime = 0L;
                    BeaconManager.logDebug(TAG, "This is Android L. Doing a filtered scan for the background.");
                    ScanSettings settings = new ScanSettings.Builder().setScanMode(0).build();
                    this.mScanner.startScan(new ScanFilterUtils().createScanFiltersForBeaconParsers(this.mBeaconManager.getBeaconParsers()), settings, this.getNewLeScanCallback());
                } else {
                    BeaconManager.logDebug(TAG, "This is Android L, but we last saw a beacon only " + secsSinceLastDetection + " ago, so we will not keep scanning in background.");
                }
            }
            if (this.mBackgroundLScanStartTime > 0L && DetectionTracker.getInstance().getLastDetectionTime() > this.mBackgroundLScanStartTime) {
                if (this.mBackgroundLScanFirstDetectionTime == 0L) {
                    this.mBackgroundLScanFirstDetectionTime = DetectionTracker.getInstance().getLastDetectionTime();
                }
                if (System.currentTimeMillis() - this.mBackgroundLScanFirstDetectionTime >= 10000L) {
                    BeaconManager.logDebug(TAG, "We've been detecting for a bit.  Stopping Android L background scanning");
                    this.mScanner.stopScan(this.getNewLeScanCallback());
                    this.mBackgroundLScanStartTime = 0L;
                } else {
                    BeaconManager.logDebug(TAG, "Delivering Android L background scanning results");
                    this.mCycledLeScanCallback.onCycleEnd();
                }
            }
            BeaconManager.logDebug(TAG, "Waiting to start full bluetooth scan for another " + millisecondsUntilStart + " milliseconds");
            if (!this.mScanDeferredBefore && this.mBackgroundFlag) {
                this.setWakeUpAlarm();
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CycledLeScannerForLollipop.this.scanLeDevice(true);
                }
            }, millisecondsUntilStart > 1000L ? 1000L : millisecondsUntilStart);
            this.mScanDeferredBefore = true;
            return true;
        }
        if (this.mBackgroundLScanStartTime > 0L) {
            BeaconManager.logDebug(TAG, "Stopping Android L background scanning to start full scan");
            this.mScanner.stopScan(this.getNewLeScanCallback());
            this.mBackgroundLScanStartTime = 0L;
        }
        this.mScanDeferredBefore = false;
        return false;
    }

    @Override
    protected void startScan() {
        ScanSettings settings;
        ArrayList filters = new ArrayList();
        if (this.mScanner == null) {
            BeaconManager.logDebug(TAG, "Making new Android L scanner");
            this.mScanner = this.getBluetoothAdapter().getBluetoothLeScanner();
        }
        if (this.mBackgroundFlag) {
            BeaconManager.logDebug(TAG, "starting scan in SCAN_MODE_LOW_POWER");
            settings = new ScanSettings.Builder().setScanMode(0).build();
        } else {
            BeaconManager.logDebug(TAG, "starting scan in SCAN_MODE_LOW_LATENCY");
            settings = new ScanSettings.Builder().setScanMode(2).build();
        }
        this.mScanner.startScan(filters, settings, this.getNewLeScanCallback());
    }

    @Override
    protected void finishScan() {
        this.mScanner.stopScan(this.getNewLeScanCallback());
        this.mScanningPaused = true;
    }

    private ScanCallback getNewLeScanCallback() {
        if (this.leScanCallback == null) {
            this.leScanCallback = new ScanCallback(){

                public void onScanResult(int callbackType, ScanResult scanResult) {
                    BeaconManager.logDebug(CycledLeScannerForLollipop.TAG, "got record");
                    CycledLeScannerForLollipop.this.mCycledLeScanCallback.onLeScan(scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
                    if (CycledLeScannerForLollipop.this.mBackgroundLScanStartTime > 0L) {
                        CycledLeScannerForLollipop.this.mBeaconManager;
                        BeaconManager.logDebug(CycledLeScannerForLollipop.TAG, "got a filtered scan result in the background.");
                    }
                }

                public void onBatchScanResults(List<ScanResult> results) {
                    BeaconManager.logDebug(CycledLeScannerForLollipop.TAG, "got batch records");
                    for (ScanResult scanResult : results) {
                        CycledLeScannerForLollipop.this.mCycledLeScanCallback.onLeScan(scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
                    }
                    if (CycledLeScannerForLollipop.this.mBackgroundLScanStartTime > 0L) {
                        CycledLeScannerForLollipop.this.mBeaconManager;
                        BeaconManager.logDebug(CycledLeScannerForLollipop.TAG, "got a filtered batch scan result in the background.");
                    }
                }

                public void onScanFailed(int i) {
                    Log.e((String)CycledLeScannerForLollipop.TAG, (String)"Scan Failed");
                }
            };
        }
        return this.leScanCallback;
    }
}

