/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.distance;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.distance.AndroidModel;
import org.altbeacon.beacon.distance.CurveFittedDistanceCalculator;
import org.altbeacon.beacon.distance.DistanceCalculator;
import org.altbeacon.beacon.distance.ModelSpecificDistanceUpdater;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModelSpecificDistanceCalculator
implements DistanceCalculator {
    Map<AndroidModel, DistanceCalculator> mModelMap;
    private static final String CONFIG_FILE = "model-distance-calculations.json";
    private static final String TAG = "ModelSpecificDistanceCalculator";
    private AndroidModel mDefaultModel;
    private DistanceCalculator mDistanceCalculator;
    private AndroidModel mModel;
    private AndroidModel mRequestedModel;
    private String mRemoteUpdateUrlString = null;
    private Context mContext;

    public ModelSpecificDistanceCalculator(Context context, String remoteUpdateUrlString) {
        this(context, remoteUpdateUrlString, AndroidModel.forThisDevice());
    }

    public ModelSpecificDistanceCalculator(Context context, String remoteUpdateUrlString, AndroidModel model) {
        this.mRequestedModel = model;
        this.mRemoteUpdateUrlString = remoteUpdateUrlString;
        this.mContext = context;
        this.loadModelMap();
        this.mDistanceCalculator = this.findCalculatorForModel(model);
    }

    public AndroidModel getModel() {
        return this.mModel;
    }

    public AndroidModel getRequestedModel() {
        return this.mRequestedModel;
    }

    @Override
    public double calculateDistance(int txPower, double rssi) {
        if (this.mDistanceCalculator == null) {
            Log.w((String)TAG, (String)"distance calculator has not been set");
            return -1.0;
        }
        return this.mDistanceCalculator.calculateDistance(txPower, rssi);
    }

    private DistanceCalculator findCalculatorForModel(AndroidModel model) {
        BeaconManager.logDebug(TAG, "Finding best distance calculator for " + model.getVersion() + "," + model.getBuildNumber() + "," + model.getModel() + "," + "" + model.getManufacturer());
        if (this.mModelMap == null) {
            Log.d((String)TAG, (String)"Cannot get distance calculator because modelMap was never initialized");
            return null;
        }
        int highestScore = 0;
        AndroidModel bestMatchingModel = null;
        for (AndroidModel candidateModel : this.mModelMap.keySet()) {
            if (candidateModel.matchScore(model) <= highestScore) continue;
            highestScore = candidateModel.matchScore(model);
            bestMatchingModel = candidateModel;
        }
        if (bestMatchingModel != null) {
            BeaconManager.logDebug(TAG, "found a match with score " + highestScore);
            BeaconManager.logDebug(TAG, "Finding best distance calculator for " + bestMatchingModel.getVersion() + "," + bestMatchingModel.getBuildNumber() + "," + bestMatchingModel.getModel() + "," + "" + bestMatchingModel.getManufacturer());
            this.mModel = bestMatchingModel;
        } else {
            this.mModel = this.mDefaultModel;
            Log.w((String)TAG, (String)"Cannot find match for this device.  Using default");
        }
        return this.mModelMap.get(this.mModel);
    }

    private void loadModelMap() {
        boolean mapLoaded = false;
        if (this.mRemoteUpdateUrlString != null && !(mapLoaded = this.loadModelMapFromFile())) {
            this.requestModelMapFromWeb();
        }
        if (!mapLoaded) {
            this.loadDefaultModelMap();
        }
        this.mDistanceCalculator = this.findCalculatorForModel(this.mRequestedModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadModelMapFromFile() {
        File file = new File(this.mContext.getFilesDir(), CONFIG_FILE);
        FileInputStream inputStream = null;
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStream = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Cannot open distance model file " + file));
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e2) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e2) {}
            }
        }
        try {
            this.buildModelMap(sb.toString());
            return true;
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)("Cannot update distance models from online database at " + this.mRemoteUpdateUrlString + " with JSON of " + sb.toString() + " due to exception "), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveJson(String jsonString) {
        FileOutputStream outputStream = null;
        try {
            outputStream = this.mContext.openFileOutput(CONFIG_FILE, 0);
            outputStream.write(jsonString.getBytes());
            outputStream.close();
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Cannot write updated distance model to local storage", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {}
        }
        Log.i((String)TAG, (String)"Successfully saved new distance model file");
        return true;
    }

    @TargetApi(value=11)
    private void requestModelMapFromWeb() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.INTERNET") != 0) {
            Log.w((String)TAG, (String)"App has no android.permission.INTERNET permission.  Cannot check for distance model updates");
            return;
        }
        new ModelSpecificDistanceUpdater(this.mContext, this.mRemoteUpdateUrlString, new ModelSpecificDistanceUpdater.CompletionHandler(){

            @Override
            public void onComplete(String body, Exception ex, int code) {
                if (ex != null) {
                    Log.w((String)ModelSpecificDistanceCalculator.TAG, (String)("Cannot updated distance models from online database at " + ModelSpecificDistanceCalculator.this.mRemoteUpdateUrlString + " due to exception: " + ex));
                } else if (code != 200) {
                    Log.w((String)ModelSpecificDistanceCalculator.TAG, (String)("Cannot updated distance models from online database at " + ModelSpecificDistanceCalculator.this.mRemoteUpdateUrlString + " due to HTTP status code " + code));
                } else {
                    BeaconManager.logDebug(ModelSpecificDistanceCalculator.TAG, "Successfully downloaded distance models from online database");
                    try {
                        ModelSpecificDistanceCalculator.this.buildModelMap(body);
                        if (ModelSpecificDistanceCalculator.this.saveJson(body)) {
                            ModelSpecificDistanceCalculator.this.loadModelMapFromFile();
                            ModelSpecificDistanceCalculator.this.mDistanceCalculator = ModelSpecificDistanceCalculator.this.findCalculatorForModel(ModelSpecificDistanceCalculator.this.mRequestedModel);
                            Log.i((String)ModelSpecificDistanceCalculator.TAG, (String)"Successfully updated distance model with latest from online database");
                        }
                    }
                    catch (JSONException e) {
                        Log.w((String)ModelSpecificDistanceCalculator.TAG, (String)"Cannot parse json from downloaded distance model", (Throwable)e);
                    }
                }
            }
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private void buildModelMap(String jsonString) throws JSONException {
        this.mModelMap = new HashMap<AndroidModel, DistanceCalculator>();
        JSONObject jsonObject = new JSONObject(jsonString);
        JSONArray array = jsonObject.getJSONArray("models");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject modelObject = array.getJSONObject(i);
            boolean defaultFlag = false;
            if (modelObject.has("default")) {
                defaultFlag = modelObject.getBoolean("default");
            }
            Double coefficient1 = modelObject.getDouble("coefficient1");
            Double coefficient2 = modelObject.getDouble("coefficient2");
            Double coefficient3 = modelObject.getDouble("coefficient3");
            String version = modelObject.getString("version");
            String buildNumber = modelObject.getString("build_number");
            String model = modelObject.getString("model");
            String manufacturer = modelObject.getString("manufacturer");
            CurveFittedDistanceCalculator distanceCalculator = new CurveFittedDistanceCalculator(coefficient1, coefficient2, coefficient3);
            AndroidModel androidModel = new AndroidModel(version, buildNumber, model, manufacturer);
            this.mModelMap.put(androidModel, distanceCalculator);
            if (!defaultFlag) continue;
            this.mDefaultModel = androidModel;
        }
    }

    private void loadDefaultModelMap() {
        this.mModelMap = new HashMap<AndroidModel, DistanceCalculator>();
        try {
            this.buildModelMap(this.stringFromFilePath(CONFIG_FILE));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Cannot build model distance calculations", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringFromFilePath(String path) throws IOException {
        InputStream stream = null;
        BufferedReader bufferedReader = null;
        StringBuilder inputStringBuilder = new StringBuilder();
        try {
            stream = ModelSpecificDistanceCalculator.class.getResourceAsStream("/" + path);
            if (stream == null) {
                stream = this.getClass().getClassLoader().getResourceAsStream("/" + path);
            }
            if (stream == null) {
                throw new RuntimeException("Cannot load resource at " + path);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String line = bufferedReader.readLine();
            while (line != null) {
                inputStringBuilder.append(line);
                inputStringBuilder.append('\n');
                line = bufferedReader.readLine();
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
        return inputStringBuilder.toString();
    }
}

