/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.Identifier;

public class Region
implements Parcelable {
    private static final String TAG = "Region";
    public static final Parcelable.Creator<Region> CREATOR = new Parcelable.Creator<Region>(){

        public Region createFromParcel(Parcel in) {
            return new Region(in);
        }

        public Region[] newArray(int size) {
            return new Region[size];
        }
    };
    protected List<Identifier> mIdentifiers;
    protected String mUniqueId;

    public Region(String uniqueId, Identifier id1, Identifier id2, Identifier id3) {
        this.mIdentifiers = new ArrayList<Identifier>(3);
        this.mIdentifiers.add(id1);
        this.mIdentifiers.add(id2);
        this.mIdentifiers.add(id3);
        this.mUniqueId = uniqueId;
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId may not be null");
        }
    }

    public Region(String uniqueId, ArrayList<Identifier> identifiers) {
        this.mIdentifiers = new ArrayList<Identifier>(3);
        this.mUniqueId = uniqueId;
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId may not be null");
        }
    }

    public Identifier getId1() {
        return this.mIdentifiers.get(0);
    }

    public Identifier getId2() {
        return this.mIdentifiers.get(1);
    }

    public Identifier getId3() {
        return this.mIdentifiers.get(2);
    }

    public Identifier getIdentifier(int i) {
        return this.mIdentifiers.get(i);
    }

    public String getUniqueId() {
        return this.mUniqueId;
    }

    public boolean matchesBeacon(Beacon beacon) {
        for (int i = 0; i < this.mIdentifiers.size(); ++i) {
            if (beacon.getIdentifiers().size() <= i && this.mIdentifiers.get(i) == null || this.mIdentifiers.get(i) == null || this.mIdentifiers.get(i).equals(beacon.mIdentifiers.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.mUniqueId.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Region) {
            return ((Region)other).mUniqueId.equals(this.mUniqueId);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (Identifier identifier : this.mIdentifiers) {
            if (i > 1) {
                sb.append(" ");
            }
            sb.append("id");
            sb.append(i);
            sb.append(": ");
            sb.append(identifier == null ? "null" : identifier.toString());
            ++i;
        }
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mUniqueId);
        out.writeInt(this.mIdentifiers.size());
        for (Identifier identifier : this.mIdentifiers) {
            if (identifier != null) {
                out.writeString(identifier.toString());
                continue;
            }
            out.writeString(null);
        }
    }

    protected Region(Region otherRegion) {
        this.mIdentifiers = new ArrayList<Identifier>(otherRegion.mIdentifiers.size());
        for (int i = 0; i < otherRegion.mIdentifiers.size(); ++i) {
            Identifier otherIdentifier = otherRegion.mIdentifiers.get(i);
            this.mIdentifiers.add(otherIdentifier != null ? new Identifier(otherIdentifier) : null);
        }
        this.mUniqueId = otherRegion.mUniqueId;
    }

    protected Region() {
    }

    protected Region(Parcel in) {
        this.mUniqueId = in.readString();
        int size = in.readInt();
        this.mIdentifiers = new ArrayList<Identifier>(size);
        for (int i = 0; i < size; ++i) {
            String identifierString = in.readString();
            if (identifierString == null) {
                this.mIdentifiers.add(null);
                continue;
            }
            Identifier identifier = Identifier.parse(identifierString);
            this.mIdentifiers.add(identifier);
        }
    }

    public Object clone() {
        return new Region(this);
    }
}

