/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.altbeacon.beacon.AltBeaconParser;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.BleNotAvailableException;
import org.altbeacon.beacon.MonitorNotifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.service.BeaconService;
import org.altbeacon.beacon.service.StartRMData;
import org.altbeacon.beacon.simulator.BeaconSimulator;

@TargetApi(value=4)
public class BeaconManager {
    private static final String TAG = "BeaconManager";
    private Context mContext;
    protected static BeaconManager client = null;
    private Map<BeaconConsumer, ConsumerInfo> consumers = new HashMap<BeaconConsumer, ConsumerInfo>();
    private Messenger serviceMessenger = null;
    protected RangeNotifier rangeNotifier = null;
    protected RangeNotifier dataRequestNotifier = null;
    protected MonitorNotifier monitorNotifier = null;
    private ArrayList<Region> monitoredRegions = new ArrayList();
    private ArrayList<Region> rangedRegions = new ArrayList();
    private ArrayList<BeaconParser> beaconParsers = new ArrayList();
    private boolean mBackgroundMode = false;
    private boolean mBackgroundModeUninitialized = true;
    public static boolean debug = false;
    private static boolean sAndroidLScanningDisabled = false;
    private static boolean sManifestCheckingDisabled = false;
    public static final long DEFAULT_FOREGROUND_SCAN_PERIOD = 1100L;
    public static final long DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD = 0L;
    public static final long DEFAULT_BACKGROUND_SCAN_PERIOD = 10000L;
    public static final long DEFAULT_BACKGROUND_BETWEEN_SCAN_PERIOD = 300000L;
    private long foregroundScanPeriod = 1100L;
    private long foregroundBetweenScanPeriod = 0L;
    private long backgroundScanPeriod = 10000L;
    private long backgroundBetweenScanPeriod = 300000L;
    private ServiceConnection beaconServiceConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            BeaconManager.logDebug(BeaconManager.TAG, "we have a connection to the service now");
            BeaconManager.this.serviceMessenger = new Messenger(service);
            Map map = BeaconManager.this.consumers;
            synchronized (map) {
                for (BeaconConsumer consumer : BeaconManager.this.consumers.keySet()) {
                    Boolean alreadyConnected = ((ConsumerInfo)((BeaconManager)BeaconManager.this).consumers.get((Object)consumer)).isConnected;
                    if (alreadyConnected.booleanValue()) continue;
                    consumer.onBeaconServiceConnect();
                    ConsumerInfo consumerInfo = (ConsumerInfo)BeaconManager.this.consumers.get(consumer);
                    consumerInfo.isConnected = true;
                    BeaconManager.this.consumers.put(consumer, consumerInfo);
                }
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            Log.e((String)BeaconManager.TAG, (String)"onServiceDisconnected");
            BeaconManager.this.serviceMessenger = null;
        }
    };
    protected static BeaconSimulator beaconSimulator;
    protected static String distanceModelUpdateUrl;

    public static void setDebug(boolean debug) {
        BeaconManager.debug = debug;
    }

    public void setForegroundScanPeriod(long p) {
        this.foregroundScanPeriod = p;
    }

    public void setForegroundBetweenScanPeriod(long p) {
        this.foregroundBetweenScanPeriod = p;
    }

    public void setBackgroundScanPeriod(long p) {
        this.backgroundScanPeriod = p;
    }

    public void setBackgroundBetweenScanPeriod(long p) {
        this.backgroundBetweenScanPeriod = p;
    }

    public static BeaconManager getInstanceForApplication(Context context) {
        if (client == null) {
            BeaconManager.logDebug(TAG, "BeaconManager instance creation");
            client = new BeaconManager(context);
        }
        return client;
    }

    public List<BeaconParser> getBeaconParsers() {
        if (this.isAnyConsumerBound()) {
            return Collections.unmodifiableList(this.beaconParsers);
        }
        return this.beaconParsers;
    }

    protected BeaconManager(Context context) {
        this.mContext = context;
        if (!sManifestCheckingDisabled) {
            this.verifyServiceDeclaration();
        }
        this.beaconParsers.add(new AltBeaconParser());
    }

    @TargetApi(value=18)
    public boolean checkAvailability() throws BleNotAvailableException {
        if (Build.VERSION.SDK_INT < 18) {
            throw new BleNotAvailableException("Bluetooth LE not supported by this device");
        }
        if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            throw new BleNotAvailableException("Bluetooth LE not supported by this device");
        }
        return ((BluetoothManager)this.mContext.getSystemService("bluetooth")).getAdapter().isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(BeaconConsumer consumer) {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to SDK 18.  Method invocation will be ignored");
            return;
        }
        Map<BeaconConsumer, ConsumerInfo> map = this.consumers;
        synchronized (map) {
            if (this.consumers.keySet().contains(consumer)) {
                BeaconManager.logDebug(TAG, "This consumer is already bound");
            } else {
                BeaconManager.logDebug(TAG, "This consumer is not bound.  binding: " + consumer);
                this.consumers.put(consumer, new ConsumerInfo());
                Intent intent = new Intent(consumer.getApplicationContext(), BeaconService.class);
                consumer.bindService(intent, this.beaconServiceConnection, 1);
                BeaconManager.logDebug(TAG, "consumer count is now:" + this.consumers.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(BeaconConsumer consumer) {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to SDK 18.  Method invocation will be ignored");
            return;
        }
        Map<BeaconConsumer, ConsumerInfo> map = this.consumers;
        synchronized (map) {
            if (this.consumers.keySet().contains(consumer)) {
                Log.d((String)TAG, (String)"Unbinding");
                consumer.unbindService(this.beaconServiceConnection);
                this.consumers.remove(consumer);
                if (this.consumers.size() == 0) {
                    this.serviceMessenger = null;
                }
            } else {
                BeaconManager.logDebug(TAG, "This consumer is not bound to: " + consumer);
                BeaconManager.logDebug(TAG, "Bound consumers: ");
                for (int i = 0; i < this.consumers.size(); ++i) {
                    Log.i((String)TAG, (String)(" " + this.consumers.get(i)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound(BeaconConsumer consumer) {
        Map<BeaconConsumer, ConsumerInfo> map = this.consumers;
        synchronized (map) {
            return this.consumers.keySet().contains(consumer) && this.serviceMessenger != null;
        }
    }

    public boolean isAnyConsumerBound() {
        return this.consumers.size() > 0 && this.serviceMessenger != null;
    }

    public void setBackgroundMode(boolean backgroundMode) {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to SDK 18.  Method invocation will be ignored");
        }
        this.mBackgroundModeUninitialized = false;
        if (backgroundMode != this.mBackgroundMode) {
            this.mBackgroundMode = backgroundMode;
            try {
                this.updateScanPeriods();
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Cannot contact service to set scan periods");
            }
        }
    }

    public boolean isBackgroundModeUninitialized() {
        return this.mBackgroundModeUninitialized;
    }

    public void setRangeNotifier(RangeNotifier notifier) {
        this.rangeNotifier = notifier;
    }

    public void setMonitorNotifier(MonitorNotifier notifier) {
        this.monitorNotifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void startRangingBeaconsInRegion(Region region) throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to SDK 18.  Method invocation will be ignored");
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)2, (int)0, (int)0);
        StartRMData obj = new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            this.rangedRegions.add((Region)region.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void stopRangingBeaconsInRegion(Region region) throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to SDK 18.  Method invocation will be ignored");
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)3, (int)0, (int)0);
        StartRMData obj = new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            Region regionToRemove = null;
            for (Region rangedRegion : this.rangedRegions) {
                if (!region.getUniqueId().equals(rangedRegion.getUniqueId())) continue;
                regionToRemove = rangedRegion;
            }
            this.rangedRegions.remove(regionToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void startMonitoringBeaconsInRegion(Region region) throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to API 18.  Method invocation will be ignored");
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)4, (int)0, (int)0);
        StartRMData obj = new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.monitoredRegions;
        synchronized (arrayList) {
            this.monitoredRegions.add((Region)region.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void stopMonitoringBeaconsInRegion(Region region) throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to API 18.  Method invocation will be ignored");
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)5, (int)0, (int)0);
        StartRMData obj = new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.monitoredRegions;
        synchronized (arrayList) {
            Region regionToRemove = null;
            for (Region monitoredRegion : this.monitoredRegions) {
                if (!region.getUniqueId().equals(monitoredRegion.getUniqueId())) continue;
                regionToRemove = monitoredRegion;
            }
            this.monitoredRegions.remove(regionToRemove);
        }
    }

    @TargetApi(value=18)
    public void updateScanPeriods() throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to API 18.  Method invocation will be ignored");
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)6, (int)0, (int)0);
        BeaconManager.logDebug(TAG, "updating background flag to " + this.mBackgroundMode);
        BeaconManager.logDebug(TAG, "updating scan period to " + this.getScanPeriod() + ", " + this.getBetweenScanPeriod());
        StartRMData obj = new StartRMData(this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
    }

    private String callbackPackageName() {
        String packageName = this.mContext.getPackageName();
        BeaconManager.logDebug(TAG, "callback packageName: " + packageName);
        return packageName;
    }

    public MonitorNotifier getMonitoringNotifier() {
        return this.monitorNotifier;
    }

    public RangeNotifier getRangingNotifier() {
        return this.rangeNotifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Region> getMonitoredRegions() {
        ArrayList<Region> clonedMontoredRegions = new ArrayList<Region>();
        ArrayList<Region> arrayList = this.monitoredRegions;
        synchronized (arrayList) {
            for (Region montioredRegion : this.monitoredRegions) {
                clonedMontoredRegions.add((Region)montioredRegion.clone());
            }
        }
        return clonedMontoredRegions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Region> getRangedRegions() {
        ArrayList<Region> clonedRangedRegions = new ArrayList<Region>();
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            for (Region rangedRegion : this.rangedRegions) {
                clonedRangedRegions.add((Region)rangedRegion.clone());
            }
        }
        return clonedRangedRegions;
    }

    public static void logDebug(String tag, String message) {
        if (debug) {
            Log.d((String)tag, (String)message);
        }
    }

    public static void logDebug(String tag, String message, Throwable t) {
        if (debug) {
            Log.d((String)tag, (String)message, (Throwable)t);
        }
    }

    public static String getDistanceModelUpdateUrl() {
        return distanceModelUpdateUrl;
    }

    public static void setDistanceModelUpdateUrl(String url) {
        distanceModelUpdateUrl = url;
    }

    public static void setBeaconSimulator(BeaconSimulator beaconSimulator) {
        BeaconManager.beaconSimulator = beaconSimulator;
    }

    public static BeaconSimulator getBeaconSimulator() {
        return beaconSimulator;
    }

    protected void setDataRequestNotifier(RangeNotifier notifier) {
        this.dataRequestNotifier = notifier;
    }

    protected RangeNotifier getDataRequestNotifier() {
        return this.dataRequestNotifier;
    }

    private long getScanPeriod() {
        if (this.mBackgroundMode) {
            return this.backgroundScanPeriod;
        }
        return this.foregroundScanPeriod;
    }

    private long getBetweenScanPeriod() {
        if (this.mBackgroundMode) {
            return this.backgroundBetweenScanPeriod;
        }
        return this.foregroundBetweenScanPeriod;
    }

    private void verifyServiceDeclaration() {
        Intent intent;
        PackageManager packageManager = this.mContext.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent(this.mContext, BeaconService.class), 65536);
        if (resolveInfo.size() == 0) {
            throw new ServiceNotDeclaredException();
        }
    }

    public static boolean isAndroidLScanningDisabled() {
        return sAndroidLScanningDisabled;
    }

    public static void setAndroidLScanningDisabled(boolean disabled) {
        sAndroidLScanningDisabled = disabled;
    }

    public static void setsManifestCheckingDisabled(boolean disabled) {
        sManifestCheckingDisabled = disabled;
    }

    static {
        distanceModelUpdateUrl = "http://data.altbeacon.org/android-distance.json";
    }

    public class ServiceNotDeclaredException
    extends RuntimeException {
        public ServiceNotDeclaredException() {
            super("The BeaconService is not properly declared in AndroidManifest.xml.  If using Eclipse, please verify that your project.properties has manifestmerger.enabled=true");
        }
    }

    private class ConsumerInfo {
        public boolean isConnected = false;

        private ConsumerInfo() {
        }
    }
}

