/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.regex.Pattern;

public class Identifier
implements Comparable<Identifier> {
    private static final Pattern HEX_PATTERN = Pattern.compile("^0x[0-9A-Fa-f]*$");
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("^[0-9]+$");
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9A-Fa-f]{8}-?[0-9A-Fa-f]{4}-?[0-9A-Fa-f]{4}-?[0-9A-Fa-f]{4}-?[0-9A-Fa-f]{12}$");
    private static final char[] hexArray = "0123456789abcdef".toCharArray();
    private static final BigInteger maxInteger = BigInteger.valueOf(65535L);
    private final byte[] mValue;

    public static Identifier parse(String stringValue) {
        if (stringValue == null) {
            throw new NullPointerException("stringValue == null");
        }
        if (HEX_PATTERN.matcher(stringValue).matches()) {
            return Identifier.parseHex(stringValue.substring(2));
        }
        if (UUID_PATTERN.matcher(stringValue).matches()) {
            return Identifier.parseHex(stringValue.replace("-", ""));
        }
        if (DECIMAL_PATTERN.matcher(stringValue).matches()) {
            BigInteger i = new BigInteger(stringValue);
            if (i.compareTo(BigInteger.ZERO) < 0 || i.compareTo(maxInteger) > 0) {
                throw new IllegalArgumentException("Decimal formatted integers must be between 0 and 65535. Value: " + stringValue);
            }
            return Identifier.fromInt(i.intValue());
        }
        throw new IllegalArgumentException("Unable to parse identifier: " + stringValue);
    }

    private static Identifier parseHex(String identifierString) {
        String str = identifierString.length() % 2 == 0 ? identifierString.toLowerCase() : "0" + identifierString.toLowerCase();
        byte[] result = new byte[str.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            int v = Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
            result[i] = (byte)v;
        }
        return new Identifier(result);
    }

    public static Identifier fromInt(int intValue) {
        if (intValue < 0 || intValue > 65535) {
            throw new IllegalArgumentException("value must be between 0 and 65535");
        }
        byte[] newValue = new byte[]{(byte)(intValue >> 8), (byte)intValue};
        return new Identifier(newValue);
    }

    public static Identifier fromBytes(byte[] bytes, int start, int end, boolean littleEndian) {
        if (bytes == null) {
            throw new NullPointerException("bytes == null");
        }
        if (start < 0 || start > bytes.length) {
            throw new ArrayIndexOutOfBoundsException("start < 0 || start > bytes.length");
        }
        if (end > bytes.length) {
            throw new ArrayIndexOutOfBoundsException("end > bytes.length");
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        byte[] byteRange = Arrays.copyOfRange(bytes, start, end);
        if (littleEndian) {
            Identifier.reverseArray(byteRange);
        }
        return new Identifier(byteRange);
    }

    @Deprecated
    public Identifier(Identifier identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier == null");
        }
        this.mValue = identifier.mValue;
    }

    protected Identifier(byte[] value) {
        if (value == null) {
            throw new NullPointerException("identifier == null");
        }
        this.mValue = value;
    }

    public String toString() {
        if (this.mValue.length == 2) {
            return Integer.toString(this.toInt());
        }
        if (this.mValue.length == 16) {
            return this.toUuidString();
        }
        return "0x" + this.toHexString();
    }

    public int toInt() {
        if (this.mValue.length > 2) {
            throw new UnsupportedOperationException("Only supported for Identifiers with max byte length of 2");
        }
        int result = 0;
        for (int i = 0; i < this.mValue.length; ++i) {
            result |= (this.mValue[i] & 0xFF) << (this.mValue.length - i - 1) * 8;
        }
        return result;
    }

    public byte[] toByteArrayOfSpecifiedEndianness(boolean bigEndian) {
        byte[] copy = Arrays.copyOf(this.mValue, this.mValue.length);
        if (!bigEndian) {
            Identifier.reverseArray(copy);
        }
        return copy;
    }

    private static void reverseArray(byte[] bytes) {
        for (int i = 0; i < bytes.length / 2; ++i) {
            byte b;
            byte a = bytes[i];
            bytes[i] = b = bytes[bytes.length - i - 1];
            bytes[bytes.length - i - 1] = a;
        }
    }

    public int getByteCount() {
        return this.mValue.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    public boolean equals(Object that) {
        if (!(that instanceof Identifier)) {
            return false;
        }
        Identifier thatIdentifier = (Identifier)that;
        return Arrays.equals(this.mValue, thatIdentifier.mValue);
    }

    private static String toHexString(byte[] bytes, int start, int length) {
        char[] hexChars = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int v = bytes[start + i] & 0xFF;
            hexChars[i * 2] = hexArray[v >>> 4];
            hexChars[i * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public String toHexString() {
        return Identifier.toHexString(this.mValue, 0, this.mValue.length);
    }

    public String toUuidString() {
        if (this.mValue.length != 16) {
            throw new UnsupportedOperationException("Only available for values with length of 16 bytes");
        }
        return Identifier.toHexString(this.mValue, 0, 4) + "-" + Identifier.toHexString(this.mValue, 4, 2) + "-" + Identifier.toHexString(this.mValue, 6, 2) + "-" + Identifier.toHexString(this.mValue, 8, 2) + "-" + Identifier.toHexString(this.mValue, 10, 6);
    }

    @Override
    public int compareTo(Identifier that) {
        if (this.mValue.length != that.mValue.length) {
            return this.mValue.length < that.mValue.length ? -1 : 1;
        }
        for (int i = 0; i < this.mValue.length; ++i) {
            if (this.mValue[i] == that.mValue[i]) continue;
            return this.mValue[i] < that.mValue[i] ? -1 : 1;
        }
        return 0;
    }
}

