/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.annotation.TargetApi;
import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.util.Collection;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.service.MonitoringData;
import org.altbeacon.beacon.service.RangingData;

@TargetApi(value=3)
public class BeaconIntentProcessor
extends IntentService {
    private static final String TAG = "BeaconIntentProcessor";
    private boolean initialized = false;

    public BeaconIntentProcessor() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        Object notifier;
        BeaconManager.logDebug(TAG, "got an intent to process");
        MonitoringData monitoringData = null;
        RangingData rangingData = null;
        if (intent != null && intent.getExtras() != null) {
            monitoringData = (MonitoringData)intent.getExtras().get("monitoringData");
            rangingData = (RangingData)intent.getExtras().get("rangingData");
        }
        if (rangingData != null) {
            BeaconManager.logDebug(TAG, "got ranging data");
            if (rangingData.getBeacons() == null) {
                Log.w((String)TAG, (String)"Ranging data has a null beacons collection");
            }
            notifier = BeaconManager.getInstanceForApplication((Context)this).getRangingNotifier();
            Collection<Beacon> beacons = rangingData.getBeacons();
            if (notifier != null) {
                notifier.didRangeBeaconsInRegion(beacons, rangingData.getRegion());
            } else {
                BeaconManager.logDebug(TAG, "but ranging notifier is null, so we're dropping it.");
            }
            RangeNotifier dataNotifier = BeaconManager.getInstanceForApplication((Context)this).getDataRequestNotifier();
            if (dataNotifier != null) {
                dataNotifier.didRangeBeaconsInRegion(beacons, rangingData.getRegion());
            }
        }
        if (monitoringData != null) {
            BeaconManager.logDebug(TAG, "got monitoring data");
            notifier = BeaconManager.getInstanceForApplication((Context)this).getMonitoringNotifier();
            if (notifier != null) {
                BeaconManager.logDebug(TAG, "Calling monitoring notifier:" + notifier);
                notifier.didDetermineStateForRegion(monitoringData.isInside() ? 1 : 0, monitoringData.getRegion());
                if (monitoringData.isInside()) {
                    notifier.didEnterRegion(monitoringData.getRegion());
                } else {
                    notifier.didExitRegion(monitoringData.getRegion());
                }
            }
        }
    }
}

