/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.startup;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.startup.BootstrapNotifier;

public class RegionBootstrap {
    protected static final String TAG = "AppStarter";
    private BeaconManager beaconManager;
    private BootstrapNotifier application;
    private List<Region> regions;
    private boolean disabled = false;
    private BeaconConsumer beaconConsumer;

    public RegionBootstrap(BootstrapNotifier application, Region region) {
        if (application.getApplicationContext() == null) {
            throw new NullPointerException("The BootstrapNotifier instance is returning null from its getApplicationContext() method.  Have you implemented this method?");
        }
        this.beaconManager = BeaconManager.getInstanceForApplication(application.getApplicationContext());
        this.application = application;
        this.regions = new ArrayList<Region>();
        this.regions.add(region);
        this.beaconConsumer = new InternalBeaconConsumer();
        this.beaconManager.bind(this.beaconConsumer);
        BeaconManager.logDebug(TAG, "Waiting for BeaconService connection");
    }

    public RegionBootstrap(BootstrapNotifier application, List<Region> regions) {
        if (application.getApplicationContext() == null) {
            throw new NullPointerException("The BootstrapNotifier instance is returning null from its getApplicationContext() method.  Have you implemented this method?");
        }
        this.beaconManager = BeaconManager.getInstanceForApplication(application.getApplicationContext());
        this.application = application;
        this.regions = regions;
        this.beaconConsumer = new InternalBeaconConsumer();
        this.beaconManager.bind(this.beaconConsumer);
        BeaconManager.logDebug(TAG, "Waiting for BeaconService connection");
    }

    public void disable() {
        if (this.disabled) {
            return;
        }
        this.disabled = true;
        try {
            for (Region region : this.regions) {
                this.beaconManager.stopMonitoringBeaconsInRegion(region);
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Can't stop bootstrap regions due to " + (Object)((Object)e)));
        }
        this.beaconManager.unbind(this.beaconConsumer);
    }

    private class InternalBeaconConsumer
    implements BeaconConsumer {
        private InternalBeaconConsumer() {
        }

        @Override
        public void onBeaconServiceConnect() {
            BeaconManager.logDebug(RegionBootstrap.TAG, "Activating background region monitoring");
            RegionBootstrap.this.beaconManager.setMonitorNotifier(RegionBootstrap.this.application);
            try {
                for (Region region : RegionBootstrap.this.regions) {
                    BeaconManager.logDebug(RegionBootstrap.TAG, "Background region monitoring activated for region " + region);
                    RegionBootstrap.this.beaconManager.startMonitoringBeaconsInRegion(region);
                    if (!RegionBootstrap.this.beaconManager.isBackgroundModeUninitialized()) continue;
                    RegionBootstrap.this.beaconManager.setBackgroundMode(true);
                }
            }
            catch (RemoteException e) {
                Log.e((String)RegionBootstrap.TAG, (String)("Can't set up bootstrap regions due to " + (Object)((Object)e)));
            }
        }

        @Override
        public boolean bindService(Intent intent, ServiceConnection conn, int arg2) {
            return RegionBootstrap.this.application.getApplicationContext().bindService(intent, conn, arg2);
        }

        @Override
        public Context getApplicationContext() {
            return RegionBootstrap.this.application.getApplicationContext();
        }

        @Override
        public void unbindService(ServiceConnection conn) {
            RegionBootstrap.this.application.getApplicationContext().unbindService(conn);
        }
    }
}

