/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.util.Log;
import java.util.Date;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScanner;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

@TargetApi(value=18)
public class CycledLeScannerForJellyBeanMr2
extends CycledLeScanner {
    private static final String TAG = "CycledLeScannerForJellyBeanMr2";
    private BluetoothAdapter.LeScanCallback leScanCallback;

    public CycledLeScannerForJellyBeanMr2(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, CycledLeScanCallback cycledLeScanCallback, BluetoothCrashResolver crashResolver) {
        super(context, scanPeriod, betweenScanPeriod, backgroundFlag, cycledLeScanCallback, crashResolver);
    }

    @Override
    protected void stopScan() {
        try {
            BluetoothAdapter bluetoothAdapter = this.getBluetoothAdapter();
            if (bluetoothAdapter != null) {
                bluetoothAdapter.stopLeScan(this.getLeScanCallback());
            }
        }
        catch (Exception e) {
            Log.w((String)"Internal Android exception scanning for beacons: ", (Throwable)e);
        }
    }

    @Override
    protected boolean deferScanIfNeeded() {
        long millisecondsUntilStart = this.mNextScanCycleStartTime - new Date().getTime();
        if (millisecondsUntilStart > 0L) {
            BeaconManager.logDebug(TAG, "Waiting to start next bluetooth scan for another " + millisecondsUntilStart + " milliseconds");
            if (this.mBackgroundFlag) {
                this.setWakeUpAlarm();
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CycledLeScannerForJellyBeanMr2.this.scanLeDevice(true);
                }
            }, millisecondsUntilStart > 1000L ? 1000L : millisecondsUntilStart);
            return true;
        }
        return false;
    }

    @Override
    protected void startScan() {
        this.getBluetoothAdapter().startLeScan(this.getLeScanCallback());
    }

    @Override
    protected void finishScan() {
        this.getBluetoothAdapter().stopLeScan(this.getLeScanCallback());
        this.mScanningPaused = true;
    }

    private BluetoothAdapter.LeScanCallback getLeScanCallback() {
        if (this.leScanCallback == null) {
            this.leScanCallback = new BluetoothAdapter.LeScanCallback(){

                public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                    BeaconManager.logDebug(CycledLeScannerForJellyBeanMr2.TAG, "got record");
                    CycledLeScannerForJellyBeanMr2.this.mCycledLeScanCallback.onLeScan(device, rssi, scanRecord);
                    CycledLeScannerForJellyBeanMr2.this.mBluetoothCrashResolver.notifyScannedDevice(device, CycledLeScannerForJellyBeanMr2.this.getLeScanCallback());
                }
            };
        }
        return this.leScanCallback;
    }
}

