/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import java.util.regex.Pattern;

public class Identifier {
    private static final String TAG = "Identifier";
    private static final Pattern HEX_PATTERN = Pattern.compile("^0x[0-9A-F-a-f]+$");
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("^[0-9]+$");
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9A-F-a-f]+-[0-9A-F-a-f]+-[0-9A-F-a-f]+-[0-9A-F-a-f]+-[0-9A-F-a-f]+$");
    private String mStringValue;

    public static Identifier parse(String identifierString) {
        return new Identifier(identifierString);
    }

    public static Identifier fromInt(int identifierInt) {
        return new Identifier(Integer.toString(identifierInt));
    }

    public Identifier(Identifier identifier) {
        if (identifier == null) {
            throw new NullPointerException("cannot construct Identifier from a null value");
        }
        this.mStringValue = identifier.mStringValue;
    }

    public String toString() {
        return this.mStringValue;
    }

    public int toInt() {
        return Integer.parseInt(this.mStringValue);
    }

    public byte[] toByteArrayOfSpecifiedEndianness(boolean bigEndian) {
        String hexString = this.toHexString();
        int length = hexString.length() / 2;
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            String hexByte = hexString.substring(i * 2, i * 2 + 2);
            byte b = (byte)Integer.parseInt(hexByte, 16);
            if (bigEndian) {
                bytes[i] = b;
                continue;
            }
            bytes[length - i - 1] = b;
        }
        return bytes;
    }

    public int getByteCount() {
        String hexString = this.toHexString();
        return hexString.length() / 2;
    }

    public boolean equals(Object that) {
        if (!(that instanceof Identifier)) {
            return false;
        }
        Identifier thatIdentifier = (Identifier)that;
        return this.mStringValue.equals(thatIdentifier.mStringValue);
    }

    private Identifier(String stringValue) {
        if (stringValue != null) {
            if (!Identifier.formatValid(stringValue)) {
                String formatProblem = null;
                formatProblem = DECIMAL_PATTERN.matcher(stringValue).find() ? "Decimal identifiers must be between 0 and 65535" : (HEX_PATTERN.matcher(stringValue).find() ? (stringValue.length() % 2 != 0 ? "Hex identifier must have an even number of digits." : "Hex identifier: " + stringValue + " is invalid") : "Identifier: " + stringValue + "  must be a decimal number, a 16-byte UUID, or a hex number starting with 0x");
                throw new NumberFormatException(formatProblem);
            }
            this.mStringValue = stringValue.toLowerCase();
        } else {
            this.mStringValue = null;
        }
    }

    private static boolean isHex(String string) {
        if (string.length() < 4) {
            return false;
        }
        if (string.length() % 2 != 0) {
            return false;
        }
        return HEX_PATTERN.matcher(string).find();
    }

    private static boolean isDecimal(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!DECIMAL_PATTERN.matcher(string).find()) {
            return false;
        }
        return Integer.parseInt(string) <= 65535;
    }

    private static boolean isUuid(String string) {
        if (string.length() != 36) {
            return false;
        }
        return UUID_PATTERN.matcher(string).find();
    }

    private static boolean formatValid(String string) {
        return Identifier.isDecimal(string) || Identifier.isHex(string) || Identifier.isUuid(string);
    }

    public String toHexString() {
        if (Identifier.isHex(this.mStringValue)) {
            return this.mStringValue.substring(2);
        }
        if (Identifier.isUuid(this.mStringValue)) {
            return this.mStringValue.replaceAll("-", "");
        }
        Integer i = Integer.parseInt(this.mStringValue);
        return String.format("%04x", i);
    }

    private Identifier() {
    }

    public int compareTo(Identifier that) {
        if (this.mStringValue == null && that.mStringValue == null) {
            return 0;
        }
        return this.mStringValue.compareTo(that.mStringValue);
    }
}

