/*
 * Decompiled with CFR 0.152.
 */
package org.agilemicroservices.autoconfigure.orm;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationSourceSupport;
import org.springframework.data.repository.query.QueryLookupStrategy;

public class PropertiesRepositoryConfigurationSource
extends RepositoryConfigurationSourceSupport {
    public static final String DRIVER_CLASS_NAME = "datasource.driver_class";
    public static final String URL = "datasource.url";
    public static final String USERNAME = "datasource.username";
    public static final String PASSWORD = "datasource.password";
    public static final String BASE_PACKAGES = "repository.base_packages";
    private Map<String, String> properties;

    public PropertiesRepositoryConfigurationSource(Map<String, String> properties, Environment environment) {
        super(environment);
        this.properties = properties;
    }

    public Object getSource() {
        return this.properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Iterable<String> getBasePackages() {
        ArrayList<String> basePackages = new ArrayList<String>(10);
        String str = this.properties.get(BASE_PACKAGES);
        if (str != null) {
            for (String o : str.trim().split(",")) {
                String packageName = o.trim();
                if (packageName.isEmpty()) continue;
                basePackages.add(o);
            }
        }
        return basePackages;
    }

    public Object getQueryLookupStrategyKey() {
        return QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND;
    }

    public String getRepositoryImplementationPostfix() {
        return "Impl";
    }

    public String getNamedQueryLocation() {
        return "";
    }

    public String getRepositoryFactoryBeanName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    public String getRepositoryBaseClassName() {
        return null;
    }

    public String getAttribute(String name) {
        return this.properties.get(name);
    }

    public boolean usesExplicitFilters() {
        return false;
    }
}

