/*
 * Decompiled with CFR 0.152.
 */
package org.agilemicroservices.autoconfigure.orm;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.agilemicroservices.autoconfigure.orm.OrmRegistration;
import org.agilemicroservices.autoconfigure.orm.PropertiesRepositoryConfigurationSource;
import org.agilemicroservices.autoconfigure.orm.RepositoryConfigurationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.jpa.repository.config.JpaRepositoryConfigExtension;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationUtils;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

public class DynamicRepositoryBeanDefinitionRegistrarSupport
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(DynamicRepositoryBeanDefinitionRegistrarSupport.class);
    public static final String FILENAME_SUFFIX = ".orm.properties";
    private Environment environment;
    private ResourceLoader resourceLoader;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        try {
            logger.debug("Scanning classpath for .orm.properties files.");
            Resource[] resources = resolver.getResources("classpath*:**/*.orm.properties");
            HashSet<String> unitNames = new HashSet<String>();
            for (Resource o : resources) {
                String prefix = this.unitNameFromFilename(o.getFilename());
                if (!unitNames.add(prefix)) continue;
                this.buildDataSourceQuietly(prefix, o, registry);
            }
        }
        catch (IOException e) {
            logger.error("Failed scanning classpath for .orm.properties files.", (Throwable)e);
        }
    }

    private void buildDataSourceQuietly(String unitName, Resource resource, BeanDefinitionRegistry registry) {
        logger.debug("Registering bean definitions for classpath resource '{}'.", (Object)resource.getFilename());
        try {
            Map<String, String> properties = this.loadProperties(resource);
            logger.info("Configuring persistence unit '{}' with properties: {}.", (Object)unitName, this.maskedProperties(properties));
            String dataSourceName = unitName + "DataSource";
            this.registerDataSourceDefinitions(dataSourceName, properties, registry);
            PropertiesRepositoryConfigurationSource source = new PropertiesRepositoryConfigurationSource(properties, this.environment);
            String entityManagerFactoryName = unitName + "EntityManagerFactory";
            this.registerEntityManagerFactoryDefinitions(entityManagerFactoryName, dataSourceName, unitName, source, registry);
            String transactionManagerName = unitName + "TransactionManager";
            this.registerTransactionManagerDefinitions(transactionManagerName, entityManagerFactoryName, registry);
            this.registerOrmRegistrationDefinitions(unitName + "OrmRegistration", dataSourceName, entityManagerFactoryName, transactionManagerName, source, registry);
            properties.put("entityManagerFactoryRef", entityManagerFactoryName);
            properties.put("transactionManagerRef", transactionManagerName);
            this.registerRepositoryDefinitions(source, registry);
        }
        catch (IOException e) {
            logger.error("Failed building data source from classpath resource '" + resource.getFilename() + "'.", (Throwable)e);
        }
    }

    private String unitNameFromFilename(String filename) {
        return filename.substring(0, filename.length() - FILENAME_SUFFIX.length()).toLowerCase();
    }

    private Map<String, String> loadProperties(Resource resource) throws IOException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Properties props = new Properties();
        props.load(resource.getInputStream());
        for (String o : props.stringPropertyNames()) {
            propertiesMap.put(o, props.getProperty(o));
        }
        return propertiesMap;
    }

    private Map<String, String> maskedProperties(Map<String, String> properties) {
        HashMap<String, String> maskedProperties = new HashMap<String, String>(properties);
        if (maskedProperties.remove("datasource.username") != null) {
            maskedProperties.put("datasource.username", "********");
        }
        if (maskedProperties.remove("datasource.password") != null) {
            maskedProperties.put("datasource.password", "********");
        }
        return maskedProperties;
    }

    private void registerDataSourceDefinitions(String beanName, Map<String, String> properties, BeanDefinitionRegistry registry) {
        logger.debug("Defining DataSource '{}'.", (Object)beanName);
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((String)DriverManagerDataSource.class.getName()).addPropertyValue("driverClassName", (Object)properties.get("datasource.driver_class")).addPropertyValue("url", (Object)properties.get("datasource.url")).addPropertyValue("username", (Object)properties.get("datasource.username")).addPropertyValue("password", (Object)properties.get("datasource.password")).getBeanDefinition());
    }

    private void registerEntityManagerFactoryDefinitions(String entityManagerFactoryName, String dataSourceName, String persistenceUnitName, PropertiesRepositoryConfigurationSource source, BeanDefinitionRegistry registry) {
        logger.debug("Defining EntityManagerFactory '{}' for DataSource '{}'.", (Object)entityManagerFactoryName, (Object)dataSourceName);
        registry.registerBeanDefinition(entityManagerFactoryName + "VendorAdapter", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((String)HibernateJpaVendorAdapter.class.getName()).getBeanDefinition());
        registry.registerBeanDefinition(entityManagerFactoryName, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((String)LocalContainerEntityManagerFactoryBean.class.getName()).addPropertyReference("jpaVendorAdapter", entityManagerFactoryName + "VendorAdapter").addPropertyReference("dataSource", dataSourceName).addPropertyValue("persistenceUnitName", (Object)persistenceUnitName).addPropertyValue("packagesToScan", source.getBasePackages()).addPropertyValue("jpaProperties", source.getProperties()).getBeanDefinition());
    }

    private void registerTransactionManagerDefinitions(String transactionManagerName, String entityManagerFactoryName, BeanDefinitionRegistry registry) {
        logger.debug("Defining PlatformTransactionManager '{}' for EntityManagerFactory '{}'.", (Object)transactionManagerName, (Object)entityManagerFactoryName);
        registry.registerBeanDefinition(transactionManagerName, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((String)JpaTransactionManager.class.getName()).addPropertyReference("entityManagerFactory", entityManagerFactoryName).getBeanDefinition());
    }

    private void registerOrmRegistrationDefinitions(String ormRegistrationName, String dataSourceName, String entityManagerFactoryName, String transactionManagerName, PropertiesRepositoryConfigurationSource source, BeanDefinitionRegistry registry) {
        logger.debug("Defining OrmRegistration '{}' with DataSource '{}', EntityManagerFactory '{}', PlatformTransactionManager '{}' and PropertiesRepositoryConfigurationSource {}.", new Object[]{ormRegistrationName, dataSourceName, entityManagerFactoryName, transactionManagerName, source});
        registry.registerBeanDefinition(ormRegistrationName, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(OrmRegistration.class).addPropertyReference("dataSource", dataSourceName).addPropertyReference("entityManagerFactory", entityManagerFactoryName).addPropertyReference("platformTransactionManager", transactionManagerName).addPropertyValue("source", (Object)source).getBeanDefinition());
    }

    private void registerRepositoryDefinitions(PropertiesRepositoryConfigurationSource configurationSource, BeanDefinitionRegistry registry) {
        JpaRepositoryConfigExtension extension = new JpaRepositoryConfigExtension();
        RepositoryConfigurationUtils.exposeRegistration((RepositoryConfigurationExtension)extension, (BeanDefinitionRegistry)registry, (RepositoryConfigurationSource)configurationSource);
        RepositoryConfigurationDelegate delegate = new RepositoryConfigurationDelegate((RepositoryConfigurationSource)configurationSource, this.resourceLoader, this.environment);
        delegate.registerRepositoriesIn(registry, (RepositoryConfigurationExtension)extension);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

