/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Collections {
    private Collections() {
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> map(K key, V value) {
        return Collections.map(Collections.entry(key, value));
    }

    public static <K, V> Map<K, V> map(Map.Entry<? extends K, ? extends V> ... entries) {
        return new EntryMap((Map.Entry[])entries);
    }

    public static <E> Set<E> set(E ... elements) {
        return new LinkedHashSet<E>(Collections.list(elements));
    }

    public static <E> List<E> list(E ... elements) {
        return Arrays.asList(elements);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntryMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -789853606407653214L;
        private final Set<Map.Entry<? extends K, ? extends V>> entries;

        private EntryMap(Map.Entry<? extends K, ? extends V> ... entries) {
            this.entries = Collections.set(entries);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entries;
        }
    }
}

