/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.runtime.api.impl.ExpressionResolver;
import org.activiti.runtime.api.impl.MappingExecutionContext;
import org.activiti.runtime.api.impl.SimpleMapExpressionEvaluator;
import org.activiti.runtime.api.impl.VariableScopeExpressionEvaluator;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.ConstantDefinition;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.Mapping;
import org.activiti.spring.process.model.ProcessConstantsMapping;
import org.activiti.spring.process.model.ProcessVariablesMapping;
import org.activiti.spring.process.model.VariableDefinition;

public class VariablesMappingProvider {
    private ProcessExtensionService processExtensionService;
    private ExpressionResolver expressionResolver;

    public VariablesMappingProvider(ProcessExtensionService processExtensionService, ExpressionResolver expressionResolver) {
        this.processExtensionService = processExtensionService;
        this.expressionResolver = expressionResolver;
    }

    protected Optional<Object> calculateMappedValue(Mapping inputMapping, DelegateExecution execution, Extension extensions) {
        if (inputMapping != null) {
            String name;
            VariableDefinition processVariableDefinition;
            if (Mapping.SourceMappingType.VALUE.equals((Object)inputMapping.getType())) {
                return Optional.of(inputMapping.getValue());
            }
            if (Mapping.SourceMappingType.VARIABLE.equals((Object)inputMapping.getType()) && (processVariableDefinition = extensions.getPropertyByName(name = inputMapping.getValue().toString())) != null) {
                return Optional.ofNullable(execution.getVariable(processVariableDefinition.getName()));
            }
        }
        return Optional.empty();
    }

    public Map<String, Object> calculateInputVariables(DelegateExecution execution) {
        Extension extensions = this.processExtensionService.getExtensionsForId(execution.getProcessDefinitionId());
        Map<String, Object> constants = this.calculateConstants(execution, extensions);
        if (extensions.hasEmptyInputsMapping(execution.getCurrentActivityId())) {
            return constants;
        }
        Map<String, Object> inboundVariables = !extensions.hasMapping(execution.getCurrentActivityId()) ? execution.getVariables() : this.calculateInputVariables(execution, extensions);
        inboundVariables = this.expressionResolver.resolveExpressionsMap(new VariableScopeExpressionEvaluator((VariableScope)execution), inboundVariables);
        inboundVariables.putAll(constants);
        return inboundVariables;
    }

    private Map<String, Object> calculateConstants(DelegateExecution execution, Extension extensions) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        ProcessConstantsMapping processConstantsMapping = extensions.getConstantForFlowElement(execution.getCurrentActivityId());
        for (Map.Entry mapping : processConstantsMapping.entrySet()) {
            constants.put((String)mapping.getKey(), ((ConstantDefinition)mapping.getValue()).getValue());
        }
        return constants;
    }

    private Map<String, Object> calculateInputVariables(DelegateExecution execution, Extension extensions) {
        HashMap<String, Object> inboundVariables = new HashMap<String, Object>();
        ProcessVariablesMapping processVariablesMapping = extensions.getMappingForFlowElement(execution.getCurrentActivityId());
        Map inputMappings = processVariablesMapping.getInputs();
        for (Map.Entry mapping : inputMappings.entrySet()) {
            Optional<Object> mappedValue = this.calculateMappedValue((Mapping)mapping.getValue(), execution, extensions);
            mappedValue.ifPresent(value -> inboundVariables.put((String)mapping.getKey(), value));
        }
        return inboundVariables;
    }

    private Optional<Object> calculateOutPutMappedValue(Mapping mapping, Map<String, Object> currentContextVariables) {
        if (mapping != null) {
            if (Mapping.SourceMappingType.VALUE.equals((Object)mapping.getType())) {
                return Optional.of(mapping.getValue());
            }
            if (Mapping.SourceMappingType.VARIABLE.equals((Object)mapping.getType())) {
                String name = mapping.getValue().toString();
                return currentContextVariables != null ? Optional.ofNullable(currentContextVariables.get(name)) : Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Map<String, Object> calculateOutPutVariables(MappingExecutionContext mappingExecutionContext, Map<String, Object> availableVariables) {
        Extension extensions = this.processExtensionService.getExtensionsForId(mappingExecutionContext.getProcessDefinitionId());
        if (extensions.hasEmptyOutputsMapping(mappingExecutionContext.getActivityId())) {
            return Collections.emptyMap();
        }
        if (!extensions.hasMapping(mappingExecutionContext.getActivityId())) {
            return availableVariables != null ? new HashMap<String, Object>(availableVariables) : Collections.emptyMap();
        }
        if (availableVariables != null && !availableVariables.isEmpty()) {
            if (this.expressionResolver.containsExpression(availableVariables)) {
                throw new ActivitiIllegalArgumentException("Expressions are not allowed as variable values in the output mapping");
            }
            return this.calculateOutPutVariables(mappingExecutionContext, extensions, availableVariables);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> calculateOutPutVariables(MappingExecutionContext mappingExecutionContext, Extension extensions, Map<String, Object> availableVariables) {
        HashMap outboundVariables = new HashMap();
        ProcessVariablesMapping processVariablesMapping = extensions.getMappingForFlowElement(mappingExecutionContext.getActivityId());
        Map outputMappings = processVariablesMapping.getOutputs();
        for (Map.Entry mapping : outputMappings.entrySet()) {
            String name = (String)mapping.getKey();
            VariableDefinition processVariableDefinition = extensions.getPropertyByName(name);
            if (processVariableDefinition == null) continue;
            this.calculateOutPutMappedValue((Mapping)mapping.getValue(), availableVariables).ifPresent(value -> outboundVariables.put(name, value));
        }
        return this.expressionResolver.resolveExpressionsMap(new SimpleMapExpressionEvaluator(availableVariables), outboundVariables);
    }
}

