/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.interceptor.NoParameters;
import com.opensymphony.xwork.util.TextParseUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterRemoverInterceptor
extends AroundInterceptor {
    private static final Log LOG = LogFactory.getLog((Class)ParameterRemoverInterceptor.class);
    private static final long serialVersionUID = 1L;
    private Set paramNames = Collections.EMPTY_SET;
    private Set paramValues = Collections.EMPTY_SET;

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        ActionContext ac;
        Map parameters;
        if (!(invocation.getAction() instanceof NoParameters) && null != this.paramNames && (parameters = (ac = invocation.getInvocationContext()).getParameters()) != null) {
            Iterator i = this.paramNames.iterator();
            while (i.hasNext()) {
                Object removeName = i.next();
                if (!parameters.containsKey(removeName)) continue;
                try {
                    String[] values = (String[])parameters.get(removeName);
                    String value = values[0];
                    if (null == value || !this.paramValues.contains(value)) continue;
                    parameters.remove(removeName);
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to convert parameter to string", (Throwable)e);
                }
            }
        }
    }

    public void setParamNames(String paramNames) {
        this.paramNames = TextParseUtil.commaDelimitedStringToSet(paramNames);
    }

    public void setParamValues(String paramValues) {
        this.paramValues = TextParseUtil.commaDelimitedStringToSet(paramValues);
    }
}

