/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config;

import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.entities.PackageConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationUtil {
    private static final Log LOG = LogFactory.getLog((Class)ConfigurationUtil.class);

    private ConfigurationUtil() {
    }

    public static List buildParentsFromString(Configuration configuration, String parent) {
        if (parent == null || parent.equals("")) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer tokenizer = new StringTokenizer(parent, ", ");
        ArrayList<PackageConfig> parents = new ArrayList<PackageConfig>();
        while (tokenizer.hasMoreTokens()) {
            String parentName = tokenizer.nextToken().trim();
            if (parentName.equals("")) continue;
            PackageConfig parentPackageContext = configuration.getPackageConfig(parentName);
            if (parentPackageContext == null) {
                LOG.error((Object)("Unable to find parent package " + parentName));
                continue;
            }
            parents.add(parentPackageContext);
        }
        return parents;
    }
}

