/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Unchainable;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.util.CompoundRoot;
import com.opensymphony.xwork.util.OgnlUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChainingInterceptor
extends AroundInterceptor {
    private static final Log _log = LogFactory.getLog((Class)ChainingInterceptor.class);
    Collection excludes;
    Collection includes;

    protected void after(ActionInvocation invocation, String result) throws Exception {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        OgnlValueStack stack = invocation.getStack();
        CompoundRoot root = stack.getRoot();
        if (root.size() > 1) {
            ArrayList list = new ArrayList(root);
            list.remove(0);
            Collections.reverse(list);
            Map ctxMap = invocation.getInvocationContext().getContextMap();
            Iterator iterator = list.iterator();
            int index = 1;
            while (iterator.hasNext()) {
                ++index;
                Object o = iterator.next();
                if (o != null) {
                    if (o instanceof Unchainable) continue;
                    OgnlUtil.copy(o, invocation.getAction(), ctxMap, this.excludes, this.includes);
                    continue;
                }
                _log.warn((Object)("compound root element at index " + index + " is null"));
            }
        }
    }

    public Collection getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection excludes) {
        this.excludes = excludes;
    }

    public Collection getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection includes) {
        this.includes = includes;
    }
}

