/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Preparable;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.interceptor.PrefixMethodInvocationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareInterceptor
extends AroundInterceptor {
    private static final long serialVersionUID = -7182584510651751135L;
    private static final Log _log = LogFactory.getLog((Class)PrepareInterceptor.class);
    private static final String PREPARE_PREFIX = "prepare";
    private static final String ALT_PREPARE_PREFIX = "prepareDo";
    private boolean alwaysInvokePrepare = true;

    public void setAlwaysInvokePrepare(String alwaysInvokePrepare) {
        this.alwaysInvokePrepare = Boolean.valueOf(alwaysInvokePrepare);
    }

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof Preparable) {
            try {
                PrefixMethodInvocationUtil.invokePrefixMethod(invocation, new String[]{PREPARE_PREFIX, ALT_PREPARE_PREFIX});
            }
            catch (Exception e) {
                _log.warn((Object)"an exception occured while trying to execute prefixed method", (Throwable)e);
            }
            if (this.alwaysInvokePrepare) {
                ((Preparable)action).prepare();
            }
        }
    }
}

