/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor.component;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.interceptor.component.ComponentConfiguration;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import com.opensymphony.xwork.interceptor.component.Disposable;
import com.opensymphony.xwork.interceptor.component.Initializable;
import com.opensymphony.xwork.interceptor.component.ResourceAware;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultComponentManager
implements ComponentManager,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$xwork$interceptor$component$DefaultComponentManager == null ? (class$com$opensymphony$xwork$interceptor$component$DefaultComponentManager = DefaultComponentManager.class$("com.opensymphony.xwork.interceptor.component.DefaultComponentManager")) : class$com$opensymphony$xwork$interceptor$component$DefaultComponentManager));
    Map enablers = new HashMap();
    Map enablers2 = new HashMap();
    private DefaultComponentManager fallback;
    private List loadOrder = new ArrayList();
    private Map resourceInstances = new HashMap();
    private Map dependentResources = new HashMap();
    private Set alreadyLoaded = new HashSet();
    private ComponentConfiguration config;
    private String scope;
    static /* synthetic */ Class class$com$opensymphony$xwork$interceptor$component$DefaultComponentManager;

    public Object getComponent(Class enablerType) {
        DefaultComponentManager dcm = this;
        Class resource = null;
        while (dcm != null && (resource = this.getPossibleResource(dcm, enablerType, true)) == null) {
            dcm = dcm.fallback;
        }
        if (resource == null) {
            return null;
        }
        try {
            ResourceEnablerPair pair = this.setupAndOptionallyCreateResource(dcm, resource);
            return pair.resource;
        }
        catch (Exception e) {
            String message = "Could not load resource with enabler " + enablerType;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    public void setFallback(ComponentManager fallback) {
        if (!(fallback instanceof DefaultComponentManager)) {
            throw new RuntimeException("Fallback must be an instance of DefaultConfigurationManager");
        }
        this.fallback = (DefaultComponentManager)fallback;
        this.config = fallback.getConfig();
    }

    public void addEnabler(Class component, Class enablerType) {
        this.enablers.put(enablerType, component);
        this.enablers2.put(component, enablerType);
    }

    public void dispose() {
        Collections.reverse(this.loadOrder);
        Iterator iterator = this.loadOrder.iterator();
        while (iterator.hasNext()) {
            Object resource = iterator.next();
            if (!(resource instanceof Disposable)) continue;
            Disposable disposable = (Disposable)resource;
            disposable.dispose();
        }
    }

    public void initializeObject(Object obj) {
        this.loadResource(obj, obj.getClass(), this);
    }

    public void registerInstance(Class componentType, Object instance) {
        if (!componentType.isInstance(instance)) {
            throw new IllegalArgumentException("The object " + instance + " is not an instance of " + componentType.getName());
        }
        this.loadResource(instance, componentType, this);
    }

    public Object getComponentInstance(Class componentType) {
        DefaultComponentManager dcm = this;
        Class enablerType = null;
        while (dcm != null && (enablerType = (Class)dcm.enablers2.get(componentType)) == null) {
            dcm = dcm.fallback;
        }
        if (enablerType == null) {
            return null;
        }
        try {
            ResourceEnablerPair pair = this.setupAndOptionallyCreateResource(dcm, componentType);
            return pair.resource;
        }
        catch (Exception e) {
            String message = "Could not load resource of type " + componentType;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    public ComponentConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(ComponentConfiguration config) {
        this.config = config;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void reset() {
        this.enablers.clear();
        this.enablers2.clear();
        this.loadOrder.clear();
        this.resourceInstances.clear();
        this.alreadyLoaded.clear();
        this.dependentResources.clear();
    }

    private Map getResourceDependencies(Class resourceClass) {
        ArrayList interfaces = new ArrayList();
        this.addAllInterfaces(resourceClass, interfaces);
        HashMap<Class, DefaultComponentManager> dependencies = new HashMap<Class, DefaultComponentManager>();
        Iterator iterator = interfaces.iterator();
        block0: while (iterator.hasNext()) {
            Class anInterface = (Class)iterator.next();
            DefaultComponentManager dcm = this;
            while (dcm != null) {
                dcm.resolveDependencies();
                Class possibleResource = this.getPossibleResource(dcm, anInterface, true);
                if (possibleResource != null) {
                    dependencies.put(possibleResource, dcm);
                    continue block0;
                }
                dcm = dcm.fallback;
            }
        }
        return dependencies;
    }

    private Class getPossibleResource(DefaultComponentManager dcm, Class anInterface, boolean retry) {
        Iterator iterator = dcm.enablers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Class key = (Class)entry.getKey();
            if (anInterface.equals(key)) {
                return (Class)entry.getValue();
            }
            if (!retry || !anInterface.getName().equals(key.getName())) continue;
            log.warn((Object)("Re-configuration IoC for scope " + dcm.scope));
            dcm.dispose();
            this.config.configure(dcm, dcm.scope);
            return this.getPossibleResource(dcm, anInterface, false);
        }
        return null;
    }

    private void addAllInterfaces(Class clazz, List allInterfaces) {
        if (clazz == null) {
            return;
        }
        Class[] interfaces = clazz.getInterfaces();
        allInterfaces.addAll(Arrays.asList(interfaces));
        this.addAllInterfaces(interfaces, allInterfaces);
        this.addAllInterfaces(clazz.getSuperclass(), allInterfaces);
    }

    private void addAllInterfaces(Class[] clazzes, List allInterfaces) {
        if (clazzes != null) {
            for (int i = 0; i < clazzes.length; ++i) {
                this.addAllInterfaces(clazzes[i], allInterfaces);
            }
        }
    }

    private Class loadResource(Object resource, Class clazz, DefaultComponentManager dcm) {
        boolean resourceNotLoaded;
        boolean bl = resourceNotLoaded = !dcm.loadOrder.contains(resource);
        if (resourceNotLoaded) {
            Map resources = this.getResourceDependencies(clazz);
            Iterator iterator = resources.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry mapEntry = iterator.next();
                Class depResource = (Class)mapEntry.getKey();
                DefaultComponentManager newDcm = (DefaultComponentManager)mapEntry.getValue();
                try {
                    ResourceEnablerPair pair = this.setupAndOptionallyCreateResource(newDcm, depResource);
                    this.setupResource(resource, pair.enabler, pair.resource);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Error loading or setting up resource: " + resources.getClass().getName()), (Throwable)e);
                }
            }
            dcm.alreadyLoaded.add(clazz);
            if (resource instanceof Initializable) {
                Initializable initializable = (Initializable)resource;
                initializable.init();
            }
            if (resource instanceof ResourceAware) {
                ResourceAware ra = (ResourceAware)resource;
                Set dr = ra.getDependentResources();
                HashMap<String, Long> times = new HashMap<String, Long>();
                Iterator iterator2 = dr.iterator();
                while (iterator2.hasNext()) {
                    String name = (String)iterator2.next();
                    times.put(name, new Long(this.getLastModified(name)));
                }
                dcm.dependentResources.put(ra, times);
            }
            dcm.resourceInstances.put(clazz, resource);
            dcm.loadOrder.add(resource);
        }
        Class enabler = (Class)dcm.enablers2.get(clazz);
        return enabler;
    }

    private long getLastModified(String name) {
        try {
            URL url = ClassLoaderUtil.getResource((String)name, this.getClass());
            File file = new File(new URI(url.toExternalForm()));
            return file.lastModified();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private ResourceEnablerPair setupAndOptionallyCreateResource(DefaultComponentManager newDcm, Class depResource) throws Exception {
        Class enabler;
        ResourceEnablerPair pair = new ResourceEnablerPair();
        Object newResource = newDcm.resourceInstances.get(depResource);
        if (newResource == null) {
            newResource = ObjectFactory.getObjectFactory().buildBean(depResource, null);
        }
        pair.resource = newResource;
        pair.enabler = enabler = this.loadResource(newResource, depResource, newDcm);
        return pair;
    }

    private void setupResource(Object resource, Class enabler, Object newResource) {
        block3: {
            if (enabler == null) {
                return;
            }
            try {
                enabler.getMethods()[0].invoke(resource, newResource);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Error invoking method for resource: " + resource.getClass().getName()), (Throwable)e);
            }
        }
    }

    private void resolveDependencies() {
        Iterator iterator = this.dependentResources.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ResourceAware ra = (ResourceAware)entry.getKey();
            Map times = (Map)entry.getValue();
            Set dr = ra.getDependentResources();
            Iterator iterator1 = dr.iterator();
            while (iterator1.hasNext()) {
                long lastMod;
                String name = (String)iterator1.next();
                long lastTime = (Long)times.get(name);
                if (lastTime >= (lastMod = this.getLastModified(name))) continue;
                this.dispose();
                this.config.configure(this, this.scope);
                continue block0;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ResourceEnablerPair {
        Class enabler;
        Object resource;

        ResourceEnablerPair() {
        }
    }
}

