/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingInterceptor
extends AroundInterceptor {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$xwork$interceptor$LoggingInterceptor == null ? (class$com$opensymphony$xwork$interceptor$LoggingInterceptor = LoggingInterceptor.class$("com.opensymphony.xwork.interceptor.LoggingInterceptor")) : class$com$opensymphony$xwork$interceptor$LoggingInterceptor));
    private static final String FINISH_MESSAGE = "Finishing execution stack for action ";
    private static final String START_MESSAGE = "Starting execution stack for action ";
    static /* synthetic */ Class class$com$opensymphony$xwork$interceptor$LoggingInterceptor;

    protected void after(ActionInvocation invocation, String result) throws Exception {
        this.logMessage(invocation, FINISH_MESSAGE);
    }

    protected void before(ActionInvocation invocation) throws Exception {
        this.logMessage(invocation, START_MESSAGE);
    }

    private void logMessage(ActionInvocation invocation, String baseMessage) {
        if (log.isInfoEnabled()) {
            StringBuffer message = new StringBuffer(baseMessage);
            String namespace = invocation.getProxy().getNamespace();
            if (namespace != null && namespace.trim().length() > 0) {
                message.append(namespace).append("/");
            }
            message.append(invocation.getProxy().getActionName());
            log.info((Object)message.toString());
        }
    }

    public int hashCode() {
        return 11;
    }

    public boolean equals(Object obj) {
        return obj instanceof LoggingInterceptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

