/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.util.CompoundRoot;
import com.opensymphony.xwork.util.XWorkConverter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OgnlUtil {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$xwork$util$OgnlUtil == null ? (class$com$opensymphony$xwork$util$OgnlUtil = OgnlUtil.class$("com.opensymphony.xwork.util.OgnlUtil")) : class$com$opensymphony$xwork$util$OgnlUtil));
    private static HashMap expressions = new HashMap();
    static /* synthetic */ Class class$com$opensymphony$xwork$util$OgnlUtil;
    static /* synthetic */ Class class$java$lang$Object;

    public static void setProperties(Map props, Object o, Map context) {
        OgnlUtil.setProperties(props, o, context, false);
    }

    public static void setProperties(Map props, Object o, Map context, boolean throwPropertyExceptions) {
        if (props == null) {
            return;
        }
        Ognl.setTypeConverter((Map)context, (TypeConverter)XWorkConverter.getInstance());
        Object oldRoot = Ognl.getRoot((Map)context);
        Ognl.setRoot((Map)context, (Object)o);
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String expression = (String)entry.getKey();
            OgnlUtil.internalSetProperty(expression, entry.getValue(), o, context, throwPropertyExceptions);
        }
        Ognl.setRoot((Map)context, (Object)oldRoot);
    }

    public static void setProperties(Map properties, Object o) {
        OgnlUtil.setProperties(properties, o, false);
    }

    public static void setProperties(Map properties, Object o, boolean throwPropertyExceptions) {
        Map context = Ognl.createDefaultContext((Object)o);
        OgnlUtil.setProperties(properties, o, context, throwPropertyExceptions);
    }

    public static void setProperty(String name, Object value, Object o, Map context) {
        OgnlUtil.setProperty(name, value, o, context, false);
    }

    public static void setProperty(String name, Object value, Object o, Map context, boolean throwPropertyExceptions) {
        Ognl.setTypeConverter((Map)context, (TypeConverter)XWorkConverter.getInstance());
        Object oldRoot = Ognl.getRoot((Map)context);
        Ognl.setRoot((Map)context, (Object)o);
        OgnlUtil.internalSetProperty(name, value, o, context, throwPropertyExceptions);
        Ognl.setRoot((Map)context, (Object)oldRoot);
    }

    public static Object getRealTarget(String property, Map context, Object root) throws OgnlException {
        if (root instanceof CompoundRoot) {
            CompoundRoot cr = (CompoundRoot)root;
            try {
                Iterator iterator = cr.iterator();
                while (iterator.hasNext()) {
                    Object target = iterator.next();
                    if (!OgnlRuntime.hasSetProperty((OgnlContext)((OgnlContext)context), target, (Object)property)) continue;
                    return target;
                }
            }
            catch (IntrospectionException ex) {
                throw new OgnlException("Cannot figure out real target class", (Throwable)ex);
            }
            return null;
        }
        return root;
    }

    public static void setValue(String name, Map context, Object root, Object value) throws OgnlException {
        Class memberType;
        String property;
        Object target;
        if (name.endsWith("]") && (target = OgnlUtil.getRealTarget(property = name.substring(0, name.lastIndexOf("[")), context, root)) != null && (memberType = (Class)XWorkConverter.getInstance().getConverter(target.getClass(), "Collection_" + property)) != null) {
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            value = converter.convertValue(context, target, null, property, value, memberType);
        }
        Ognl.setValue((Object)OgnlUtil.compile(name), (Map)context, (Object)root, (Object)value);
    }

    public static Object compile(String expression) throws OgnlException {
        Object o = expressions.get(expression);
        if (o == null) {
            o = Ognl.parseExpression((String)expression);
            expressions.put(expression, o);
        }
        return o;
    }

    public static void copy(Object from, Object to, Map context) {
        int i;
        BeanInfo beanInfoTo;
        BeanInfo beanInfoFrom;
        Map contextFrom = Ognl.createDefaultContext((Object)from);
        Ognl.setTypeConverter((Map)contextFrom, (TypeConverter)XWorkConverter.getInstance());
        Map contextTo = Ognl.createDefaultContext((Object)to);
        Ognl.setTypeConverter((Map)contextTo, (TypeConverter)XWorkConverter.getInstance());
        try {
            beanInfoFrom = Introspector.getBeanInfo(from.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = OgnlUtil.class$("java.lang.Object")) : class$java$lang$Object);
            beanInfoTo = Introspector.getBeanInfo(to.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = OgnlUtil.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (IntrospectionException e) {
            log.error((Object)"An error occured", (Throwable)e);
            return;
        }
        PropertyDescriptor[] fromPds = beanInfoFrom.getPropertyDescriptors();
        PropertyDescriptor[] toPds = beanInfoTo.getPropertyDescriptors();
        HashMap<String, PropertyDescriptor> toPdHash = new HashMap<String, PropertyDescriptor>();
        for (i = 0; i < toPds.length; ++i) {
            PropertyDescriptor toPd = toPds[i];
            toPdHash.put(toPd.getName(), toPd);
        }
        for (i = 0; i < fromPds.length; ++i) {
            PropertyDescriptor toPd;
            PropertyDescriptor fromPd = fromPds[i];
            if (fromPd.getReadMethod() == null || (toPd = (PropertyDescriptor)toPdHash.get(fromPd.getName())) == null || toPd.getWriteMethod() == null) continue;
            try {
                Object expr = OgnlUtil.compile(fromPd.getName());
                Object value = Ognl.getValue((Object)expr, (Map)contextFrom, (Object)from);
                Ognl.setValue((Object)expr, (Map)contextTo, (Object)to, (Object)value);
                continue;
            }
            catch (OgnlException e) {
                // empty catch block
            }
        }
    }

    static void internalSetProperty(String name, Object value, Object o, Map context, boolean throwPropertyExceptions) {
        try {
            OgnlUtil.setValue(name, context, o, value);
        }
        catch (OgnlException e) {
            Throwable exception;
            Throwable reason = e.getReason();
            String msg = "Caught OgnlException while setting property '" + name + "' on type '" + o.getClass().getName() + "'.";
            Throwable throwable = exception = reason == null ? e : reason;
            if (throwPropertyExceptions) {
                log.error((Object)msg, exception);
                throw new RuntimeException(msg);
            }
            log.warn((Object)msg, exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

