/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.tiles;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.ServletDispatcherResult;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.LocaleProvider;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.ComponentContext;
import org.apache.tiles.ComponentDefinition;
import org.apache.tiles.ComponentDefinitions;
import org.apache.tiles.Controller;
import org.apache.tiles.DefinitionsFactory;

public class TilesResult
extends ServletDispatcherResult {
    private static final Log log = LogFactory.getLog((Class)TilesResult.class);
    protected ActionInvocation invocation;
    private DefinitionsFactory definitionsFactory;

    public void doExecute(String location, ActionInvocation invocation) throws Exception {
        String path;
        this.location = location;
        this.invocation = invocation;
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ServletContext servletContext = ServletActionContext.getServletContext();
        this.definitionsFactory = (DefinitionsFactory)servletContext.getAttribute("org.apache.tiles.DEFINITIONS_FACTORY");
        ComponentDefinition definition = this.getComponentDefinition(this.definitionsFactory, request);
        if (definition == null) {
            throw new ServletException("No Tiles definition found for name '" + location + "'");
        }
        ComponentContext context = this.getComponentContext(definition, request);
        ComponentContext.setContext((ComponentContext)context, (ServletRequest)request);
        Controller controller = this.getController(definition, request);
        if (controller != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing Tiles controller [" + controller + "]"));
            }
            this.executeController(controller, context, request, response);
        }
        if ((path = this.getDispatcherPath(definition, request)) == null) {
            throw new ServletException("Could not determine a path for Tiles definition '" + definition.getName() + "'");
        }
        super.doExecute(path, invocation);
    }

    protected Locale deduceLocale(HttpServletRequest request) {
        if (this.invocation.getAction() instanceof LocaleProvider) {
            return ((LocaleProvider)this.invocation.getAction()).getLocale();
        }
        return request.getLocale();
    }

    protected ComponentDefinition getComponentDefinition(DefinitionsFactory factory, HttpServletRequest request) throws Exception {
        ComponentDefinitions definitions = factory.readDefinitions();
        return definitions.getDefinition(this.location, this.deduceLocale(request));
    }

    protected ComponentContext getComponentContext(ComponentDefinition definition, HttpServletRequest request) throws Exception {
        ComponentContext context = ComponentContext.getContext((ServletRequest)request);
        if (context == null) {
            context = new ComponentContext(definition.getAttributes());
            ComponentContext.setContext((ComponentContext)context, (ServletRequest)request);
        } else {
            context.addMissing(definition.getAttributes());
        }
        return context;
    }

    protected Controller getController(ComponentDefinition definition, HttpServletRequest request) throws Exception {
        return definition.getOrCreateController();
    }

    protected void executeController(Controller controller, ComponentContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        controller.execute(context, request, response, ServletActionContext.getServletContext());
    }

    protected String getDispatcherPath(ComponentDefinition definition, HttpServletRequest request) throws Exception {
        Object pathAttr = null;
        return pathAttr != null ? pathAttr.toString() : definition.getPath();
    }
}

