/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.util.FileManager;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.ApplicationMap;
import com.opensymphony.webwork.dispatcher.RequestMap;
import com.opensymphony.webwork.dispatcher.SessionMap;
import com.opensymphony.webwork.dispatcher.WebWorkRequestWrapper;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequest;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.webwork.util.AttributeMap;
import com.opensymphony.webwork.util.ObjectFactoryDestroyable;
import com.opensymphony.webwork.util.ObjectFactoryInitializable;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.ObjectTypeDeterminer;
import com.opensymphony.xwork.util.ObjectTypeDeterminerFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DispatcherUtils {
    private static final Log LOG = LogFactory.getLog((Class)DispatcherUtils.class);
    private static DispatcherUtils instance;
    private static boolean portletSupportActive;
    protected boolean devMode = false;
    protected boolean paramsWorkaroundEnabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(ServletContext servletContext) {
        Class clazz = DispatcherUtils.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new DispatcherUtils(servletContext);
            }
        }
    }

    public static DispatcherUtils getInstance() {
        return instance;
    }

    public static void setInstance(DispatcherUtils instance) {
        DispatcherUtils.instance = instance;
    }

    protected DispatcherUtils(ServletContext servletContext) {
        this.init(servletContext);
    }

    protected void cleanup() {
        ObjectFactory objectFactory = ObjectFactory.getObjectFactory();
        if (objectFactory == null) {
            LOG.warn((Object)"Object Factory is null, something is seriously wrong, no clean up will be performed");
        }
        if (objectFactory instanceof ObjectFactoryDestroyable) {
            try {
                ((ObjectFactoryDestroyable)objectFactory).destroy();
            }
            catch (Exception e) {
                LOG.error((Object)("exception occurred while destroying ObjectFactory [" + objectFactory + "]"), (Throwable)e);
            }
        }
    }

    protected void init(ServletContext servletContext) {
        block23: {
            Class clazz;
            String className;
            boolean reloadi18n = Boolean.valueOf((String)Configuration.get("webwork.i18n.reload"));
            LocalizedTextUtil.setReloadBundles((boolean)reloadi18n);
            if (Configuration.isSet("webwork.objectFactory")) {
                className = (String)Configuration.get("webwork.objectFactory");
                if (className.equals("spring")) {
                    className = "com.opensymphony.webwork.spring.WebWorkSpringObjectFactory";
                } else if (className.equals("plexus")) {
                    className = "com.opensymphony.webwork.plexus.PlexusObjectFactory";
                }
                try {
                    clazz = ClassLoaderUtil.loadClass((String)className, (Class)DispatcherUtils.class);
                    ObjectFactory objectFactory = (ObjectFactory)clazz.newInstance();
                    if (objectFactory instanceof ObjectFactoryInitializable) {
                        ((ObjectFactoryInitializable)objectFactory).init(servletContext);
                    }
                    ObjectFactory.setObjectFactory((ObjectFactory)objectFactory);
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not load ObjectFactory named " + className + ". Using default ObjectFactory."), (Throwable)e);
                }
            }
            if (Configuration.isSet("webwork.objectTypeDeterminer")) {
                className = (String)Configuration.get("webwork.objectTypeDeterminer");
                if (className.equals("tiger")) {
                    className = "com.opensymphony.xwork.util.GenericsObjectTypeDeterminer";
                } else if (className.equals("notiger")) {
                    className = "com.opensymphony.xwork.util.DefaultObjectTypeDeterminer";
                }
                try {
                    clazz = ClassLoaderUtil.loadClass((String)className, (Class)DispatcherUtils.class);
                    ObjectTypeDeterminer objectTypeDeterminer = (ObjectTypeDeterminer)clazz.newInstance();
                    ObjectTypeDeterminerFactory.setInstance((ObjectTypeDeterminer)objectTypeDeterminer);
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not load ObjectTypeDeterminer named " + className + ". Using default DefaultObjectTypeDeterminer."), (Throwable)e);
                }
            }
            if ("true".equals(Configuration.get("webwork.devMode"))) {
                this.devMode = true;
                Configuration.set("webwork.i18n.reload", "true");
                Configuration.set("webwork.configuration.xml.reload", "true");
            }
            if ("true".equalsIgnoreCase(Configuration.getString("webwork.configuration.xml.reload"))) {
                FileManager.setReloadingConfigs((boolean)true);
            }
            if (Configuration.isSet("webwork.continuations.package")) {
                String pkg = Configuration.getString("webwork.continuations.package");
                ObjectFactory.setContinuationPackage((String)pkg);
            }
            if (servletContext.getServerInfo().indexOf("WebLogic") >= 0) {
                LOG.info((Object)"WebLogic server detected. Enabling WebWork parameter access work-around.");
                this.paramsWorkaroundEnabled = true;
            } else if (Configuration.isSet("webwork.dispatcher.parametersWorkaround")) {
                this.paramsWorkaroundEnabled = "true".equals(Configuration.get("webwork.dispatcher.parametersWorkaround"));
            } else {
                LOG.debug((Object)"Parameter access work-around disabled.");
            }
            try {
                Class clazz2 = ClassLoaderUtil.loadClass((String)"javax.portlet.PortletRequest", (Class)DispatcherUtils.class);
                portletSupportActive = true;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Found portlet-api. Activating webwork's portlet support");
                }
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) break block23;
                LOG.info((Object)"Could not load portlet-api, disabling webwork's portlet support.");
            }
        }
    }

    public void serviceAction(HttpServletRequest request, HttpServletResponse response, ServletContext context, ActionMapping mapping) throws ServletException {
        Map extraContext = this.createContextMap(request, response, mapping, context);
        OgnlValueStack stack = (OgnlValueStack)request.getAttribute("webwork.valueStack");
        if (stack != null) {
            extraContext.put("com.opensymphony.xwork.util.OgnlValueStack.ValueStack", new OgnlValueStack(stack));
        }
        try {
            String namespace = mapping.getNamespace();
            String name = mapping.getName();
            String method = mapping.getMethod();
            String id = request.getParameter("__continue");
            if (id != null) {
                Map params = (Map)extraContext.get("com.opensymphony.xwork.ActionContext.parameters");
                params.remove("__continue");
                extraContext.put("__continue", id);
            }
            ActionProxy proxy = ActionProxyFactory.getFactory().createActionProxy(namespace, name, extraContext, true, false);
            proxy.setMethod(method);
            request.setAttribute("webwork.valueStack", (Object)proxy.getInvocation().getStack());
            if (mapping.getResult() != null) {
                Result result = mapping.getResult();
                result.execute(proxy.getInvocation());
            } else {
                proxy.execute();
            }
            if (stack != null) {
                request.setAttribute("webwork.valueStack", (Object)stack);
            }
        }
        catch (ConfigurationException e) {
            LOG.error((Object)"Could not find action", (Throwable)e);
            this.sendError(request, response, 404, (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Could not execute action";
            LOG.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
    }

    public Map createContextMap(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping, ServletContext context) {
        RequestMap requestMap = new RequestMap(request);
        HashMap params = null;
        if (mapping != null) {
            params = mapping.getParams();
        }
        HashMap requestParams = new HashMap(request.getParameterMap());
        if (params != null) {
            params.putAll(requestParams);
        } else {
            params = requestParams;
        }
        SessionMap session = new SessionMap(request);
        ApplicationMap application = new ApplicationMap(context);
        return this.createContextMap(requestMap, params, session, application, request, response, context);
    }

    public HashMap createContextMap(Map requestMap, Map parameterMap, Map sessionMap, Map applicationMap, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork.ActionContext.parameters", new HashMap(parameterMap));
        extraContext.put("com.opensymphony.xwork.ActionContext.session", sessionMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.application", applicationMap);
        Locale locale = null;
        locale = Configuration.isSet("webwork.locale") ? LocalizedTextUtil.localeFromString((String)Configuration.getString("webwork.locale"), (Locale)request.getLocale()) : request.getLocale();
        extraContext.put("com.opensymphony.xwork.ActionContext.locale", locale);
        extraContext.put("__devMode", this.devMode);
        extraContext.put("com.opensymphony.xwork.dispatcher.HttpServletRequest", request);
        extraContext.put("com.opensymphony.xwork.dispatcher.HttpServletResponse", response);
        extraContext.put("com.opensymphony.xwork.dispatcher.ServletContext", servletContext);
        extraContext.put("com.opensymphony.xwork.interceptor.component.ComponentManager", request.getAttribute("DefaultComponentManager"));
        extraContext.put("request", requestMap);
        extraContext.put("session", sessionMap);
        extraContext.put("application", applicationMap);
        extraContext.put("parameters", parameterMap);
        AttributeMap attrMap = new AttributeMap(extraContext);
        extraContext.put("attr", attrMap);
        return extraContext;
    }

    public static int getMaxSize() {
        Integer maxSize = new Integer(Integer.MAX_VALUE);
        try {
            String maxSizeStr = Configuration.getString("webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    maxSize = new Integer(maxSizeStr);
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
                }
            } else {
                LOG.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException e1) {
            LOG.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("maxSize=" + maxSize));
        }
        return maxSize;
    }

    public String getSaveDir(ServletContext servletContext) {
        String saveDir = Configuration.getString("webwork.multipart.saveDir").trim();
        if (saveDir.equals("")) {
            File tempdir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            LOG.info((Object)"Unable to find 'webwork.multipart.saveDir' property setting. Defaulting to javax.servlet.context.tempdir");
            if (tempdir != null) {
                saveDir = tempdir.toString();
            }
        } else {
            File multipartSaveDir = new File(saveDir);
            if (!multipartSaveDir.exists()) {
                multipartSaveDir.mkdir();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveDir=" + saveDir));
        }
        return saveDir;
    }

    public void prepare(HttpServletRequest request, HttpServletResponse response) {
        String encoding = null;
        if (Configuration.isSet("webwork.i18n.encoding")) {
            encoding = Configuration.getString("webwork.i18n.encoding");
        }
        Locale locale = null;
        if (Configuration.isSet("webwork.locale")) {
            locale = LocalizedTextUtil.localeFromString((String)Configuration.getString("webwork.locale"), (Locale)request.getLocale());
        }
        if (encoding != null && !MultiPartRequest.isMultiPart(request)) {
            try {
                request.setCharacterEncoding(encoding);
            }
            catch (Exception e) {
                LOG.error((Object)("Error setting character encoding to '" + encoding + "' - ignoring."), (Throwable)e);
            }
        }
        if (locale != null) {
            response.setLocale(locale);
        }
        if (this.paramsWorkaroundEnabled) {
            request.getParameter("foo");
        }
    }

    public HttpServletRequest wrapRequest(HttpServletRequest request, ServletContext servletContext) throws IOException {
        if (request instanceof WebWorkRequestWrapper) {
            return request;
        }
        request = MultiPartRequest.isMultiPart(request) ? new MultiPartRequestWrapper((HttpServletRequest)request, this.getSaveDir(servletContext), DispatcherUtils.getMaxSize()) : new WebWorkRequestWrapper((HttpServletRequest)request);
        return request;
    }

    public void sendError(HttpServletRequest request, HttpServletResponse response, int code, Exception e) {
        try {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            response.sendError(code, e.getMessage());
        }
        catch (IOException e1) {
            // empty catch block
        }
    }

    public static boolean isPortletSupportActive() {
        return portletSupportActive;
    }
}

