/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionContextCleanUp
implements Filter {
    private static final Log LOG = LogFactory.getLog((Class)ActionContextCleanUp.class);
    private static final String CLEANUP_PRESENT = "__cleanup_present";
    protected FilterConfig filterConfig;

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        DispatcherUtils.initialize(filterConfig.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        DispatcherUtils du = DispatcherUtils.getInstance();
        du.prepare(request, response);
        ServletContext servletContext = this.filterConfig.getServletContext();
        try {
            request = du.wrapRequest(request, servletContext);
        }
        catch (IOException e) {
            String message = "Could not wrap servlet request with MultipartRequestWrapper!";
            LOG.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        try {
            request.setAttribute(CLEANUP_PRESENT, (Object)Boolean.TRUE);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            request.setAttribute(CLEANUP_PRESENT, (Object)Boolean.FALSE);
            ActionContextCleanUp.cleanUp((ServletRequest)request);
        }
    }

    protected static void cleanUp(ServletRequest req) {
        Boolean dontClean = (Boolean)req.getAttribute(CLEANUP_PRESENT);
        if (dontClean != null && dontClean.booleanValue()) {
            return;
        }
        ComponentManager componentManager = (ComponentManager)req.getAttribute("DefaultComponentManager");
        if (componentManager != null) {
            componentManager.dispose();
        }
        ActionContext.setContext(null);
    }

    public void destroy() {
    }
}

