/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.hibernate;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;

public class OSCache
implements Cache {
    private GeneralCacheAdministrator cache;
    private final int refreshPeriod;
    private final String cron;
    private final String regionName;
    private final String[] regionGroups;

    public OSCache(GeneralCacheAdministrator cache, int refreshPeriod, String cron, String region) {
        this.cache = cache;
        this.refreshPeriod = refreshPeriod;
        this.cron = cron;
        this.regionName = region;
        this.regionGroups = new String[]{region};
    }

    public Object get(Object key) throws CacheException {
        try {
            return this.cache.getFromCache(this.toString(key), this.refreshPeriod, this.cron);
        }
        catch (NeedsRefreshException e) {
            this.cache.cancelUpdate(this.toString(key));
            return null;
        }
    }

    public void put(Object key, Object value) throws CacheException {
        this.cache.putInCache(this.toString(key), value, this.regionGroups);
    }

    public void remove(Object key) throws CacheException {
        this.cache.flushEntry(this.toString(key));
    }

    public void clear() throws CacheException {
        this.cache.flushGroup(this.regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws CacheException {
        GeneralCacheAdministrator generalCacheAdministrator = this.cache;
        synchronized (generalCacheAdministrator) {
            this.cache.destroy();
        }
    }

    public void lock(Object key) throws CacheException {
    }

    public void unlock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }

    public Map toMap() {
        throw new UnsupportedOperationException();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    public Object read(Object key) throws CacheException {
        return this.get(key);
    }

    private String toString(Object key) {
        return String.valueOf(key) + "." + this.regionName;
    }
}

