/*
 * Decompiled with CFR 0.152.
 */
package online.devliving.passcodeview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import online.devliving.passcodeview.R;

public class PasscodeView
extends ViewGroup {
    EditText mEditText;
    int mDigitCount;
    private int mDigitWidth;
    private int mDigitRadius;
    private int mOuterStrokeWidth;
    private int mInnerStrokeWidth;
    private int mDigitInnerRadius;
    private int mDigitSpacing;
    private int mDigitElevation;
    private int mControlColor;
    private int mHighlightedColor;
    private int mInnerColor;
    private int mInnerBorderColor;
    private View.OnFocusChangeListener mOnFocusChangeListener;
    private PasscodeEntryListener mPasscodeEntryListener;

    public PasscodeView(Context context) {
        this(context, null);
    }

    public PasscodeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PasscodeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.PasscodeView);
        this.mDigitCount = array.getInt(R.styleable.PasscodeView_numDigits, 4);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mDigitRadius = array.getDimensionPixelSize(R.styleable.PasscodeView_digitRadius, (int)TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)metrics));
        this.mOuterStrokeWidth = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)metrics);
        this.mInnerStrokeWidth = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)metrics);
        this.mDigitInnerRadius = array.getDimensionPixelSize(R.styleable.PasscodeView_digitInnerRadius, this.mDigitRadius - (int)TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)metrics));
        if (this.mDigitInnerRadius > this.mDigitRadius) {
            this.mDigitInnerRadius = this.mDigitRadius - (int)TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)metrics);
        }
        this.mDigitWidth = (this.mDigitRadius + this.mOuterStrokeWidth) * 2;
        this.mDigitSpacing = (int)TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)metrics);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mDigitElevation = array.getDimensionPixelSize(R.styleable.PasscodeView_digitElevation, 0);
        }
        Resources.Theme theme = this.getContext().getTheme();
        this.mControlColor = -12303292;
        if (Build.VERSION.SDK_INT >= 21) {
            TypedValue controlColor = new TypedValue();
            theme.resolveAttribute(16843817, controlColor, true);
            this.mControlColor = controlColor.resourceId > 0 ? this.getResources().getColor(controlColor.resourceId) : controlColor.data;
        }
        this.mControlColor = array.getColor(R.styleable.PasscodeView_controlColor, this.mControlColor);
        this.mHighlightedColor = -3355444;
        if (Build.VERSION.SDK_INT >= 21) {
            TypedValue accentColor = new TypedValue();
            theme.resolveAttribute(R.attr.colorControlHighlight, accentColor, true);
            this.mHighlightedColor = accentColor.resourceId > 0 ? this.getResources().getColor(accentColor.resourceId) : accentColor.data;
        }
        this.mHighlightedColor = array.getColor(R.styleable.PasscodeView_controlColorActivated, this.mHighlightedColor);
        this.mInnerColor = -16711681;
        if (Build.VERSION.SDK_INT >= 21) {
            TypedValue innerColor = new TypedValue();
            theme.resolveAttribute(16843827, innerColor, true);
            this.mInnerColor = innerColor.resourceId > 0 ? this.getResources().getColor(innerColor.resourceId) : innerColor.data;
        }
        this.mInnerColor = array.getColor(R.styleable.PasscodeView_digitColorFilled, this.mInnerColor);
        this.mInnerBorderColor = -16711936;
        if (Build.VERSION.SDK_INT >= 21) {
            TypedValue innerBorderColor = new TypedValue();
            theme.resolveAttribute(16843828, innerBorderColor, true);
            this.mInnerBorderColor = innerBorderColor.resourceId > 0 ? this.getResources().getColor(innerBorderColor.resourceId) : innerBorderColor.data;
        }
        this.mInnerBorderColor = array.getColor(R.styleable.PasscodeView_digitColorBorder, this.mInnerBorderColor);
        array.recycle();
        this.setupViews();
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).measure(widthMeasureSpec, heightMeasureSpec);
        }
        int width = this.mDigitWidth * this.mDigitCount + this.mDigitSpacing * (this.mDigitCount - 1);
        this.setMeasuredDimension(width + this.getPaddingLeft() + this.getPaddingRight() + this.mDigitElevation * 2, this.mDigitWidth + this.getPaddingTop() + this.getPaddingBottom() + this.mDigitElevation * 2);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        for (int i = 0; i < this.mDigitCount; ++i) {
            View child = this.getChildAt(i);
            int left = i * this.mDigitWidth + (i > 0 ? i * this.mDigitSpacing : 0);
            child.layout(left + this.getPaddingLeft() + this.mDigitElevation, this.getPaddingTop() + this.mDigitElevation / 2, left + this.getPaddingLeft() + this.mDigitElevation + this.mDigitWidth, this.getPaddingTop() + this.mDigitElevation / 2 + this.mDigitWidth);
        }
        this.getChildAt(this.mDigitCount).layout(0, 0, 1, this.getMeasuredHeight());
    }

    private void setupViews() {
        this.setWillNotDraw(false);
        for (int i = 0; i < this.mDigitCount; ++i) {
            DigitView digitView = new DigitView(this.getContext(), i);
            if (Build.VERSION.SDK_INT >= 21) {
                digitView.setElevation(this.mDigitElevation);
            }
            this.addView(digitView);
        }
        this.mEditText = new EditText(this.getContext());
        this.mEditText.setBackgroundColor(this.getResources().getColor(17170445));
        this.mEditText.setTextColor(this.getResources().getColor(17170445));
        this.mEditText.setCursorVisible(false);
        this.mEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.mDigitCount)});
        this.mEditText.setInputType(2);
        this.mEditText.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)"1234567890"));
        this.mEditText.setImeOptions(0x10000000);
        this.mEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                int length = PasscodeView.this.mEditText.getText().length();
                PasscodeView.this.updateChilViewSelectionStates(length, hasFocus);
                PasscodeView.this.mEditText.setSelection(length);
                if (PasscodeView.this.mOnFocusChangeListener != null) {
                    PasscodeView.this.mOnFocusChangeListener.onFocusChange((View)PasscodeView.this, hasFocus);
                }
            }
        });
        this.mEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                int length = s.length();
                PasscodeView.this.updateChilViewSelectionStates(length, PasscodeView.this.mEditText.hasFocus());
                if (length == PasscodeView.this.mDigitCount && PasscodeView.this.mPasscodeEntryListener != null) {
                    PasscodeView.this.mPasscodeEntryListener.onPasscodeEntered(s.toString());
                }
            }
        });
        this.addView((View)this.mEditText);
        this.invalidate();
    }

    private void updateChilViewSelectionStates(int length, boolean hasFocus) {
        for (int i = 0; i < this.mDigitCount; ++i) {
            this.getChildAt(i).setSelected(hasFocus && i == length);
        }
    }

    public Editable getText() {
        return this.mEditText.getText();
    }

    public void setText(CharSequence text) {
        if (text.length() > this.mDigitCount) {
            text = text.subSequence(0, this.mDigitCount);
        }
        this.mEditText.setText(text);
        this.invalidateChildViews();
    }

    public void clearText() {
        this.mEditText.setText((CharSequence)"");
        this.invalidateChildViews();
    }

    private void invalidateChildViews() {
        for (int i = 0; i < this.mDigitCount; ++i) {
            this.getChildAt(i).invalidate();
        }
    }

    public void setPasscodeEntryListener(PasscodeEntryListener mPasscodeEntryListener) {
        this.mPasscodeEntryListener = mPasscodeEntryListener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.requestToShowKeyboard();
            return true;
        }
        return super.onTouchEvent(event);
    }

    public void requestToShowKeyboard() {
        this.mEditText.requestFocus();
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this.mEditText, 0);
    }

    public View.OnFocusChangeListener getOnFocusChangeListener() {
        return this.mOnFocusChangeListener;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener l) {
        this.mOnFocusChangeListener = l;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState = new SavedState(parcelable);
        savedState.editTextValue = this.mEditText.getText().toString();
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mEditText.setText((CharSequence)savedState.editTextValue);
        this.mEditText.setSelection(savedState.editTextValue.length());
    }

    public static interface PasscodeEntryListener {
        public void onPasscodeEntered(String var1);
    }

    class DigitView
    extends View {
        private Paint mOuterPaint;
        private Paint mInnerPaint;
        private int mPosition;

        public DigitView(Context context, int position) {
            this(context);
            this.mPosition = position;
        }

        public DigitView(Context context) {
            this(context, null);
        }

        public DigitView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        public DigitView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
            this.mPosition = 0;
            this.init();
        }

        void init() {
            this.setWillNotDraw(false);
            if (Build.VERSION.SDK_INT >= 11) {
                this.setLayerType(1, null);
            }
            this.mOuterPaint = new Paint(1);
            this.mOuterPaint.setAlpha(255);
            this.mOuterPaint.setDither(true);
            this.mOuterPaint.setStyle(Paint.Style.STROKE);
            this.mOuterPaint.setStrokeWidth((float)PasscodeView.this.mOuterStrokeWidth);
            this.mOuterPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mOuterPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mOuterPaint.setShadowLayer(2.0f, 0.0f, 0.0f, Color.parseColor((String)"#B4999999"));
            this.mInnerPaint = new Paint(1);
            this.mInnerPaint.setAlpha(255);
            this.mInnerPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.mInnerPaint.setStrokeWidth((float)PasscodeView.this.mInnerStrokeWidth);
            this.mInnerPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mInnerPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mInnerPaint.setColor(PasscodeView.this.mInnerColor);
            this.invalidate();
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(PasscodeView.this.mDigitWidth, PasscodeView.this.mDigitWidth);
        }

        protected void onDraw(Canvas canvas) {
            float center = this.getWidth() / 2;
            if (this.isSelected()) {
                this.mOuterPaint.setColor(PasscodeView.this.mHighlightedColor);
            } else {
                this.mOuterPaint.setColor(PasscodeView.this.mControlColor);
            }
            canvas.drawColor(0);
            canvas.drawCircle(center, center, (float)PasscodeView.this.mDigitRadius, this.mOuterPaint);
            if (PasscodeView.this.mEditText.getText().length() > this.mPosition) {
                canvas.drawCircle(center, center, (float)PasscodeView.this.mDigitInnerRadius, this.mInnerPaint);
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        String editTextValue;

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel source) {
            super(source);
            this.editTextValue = source.readString();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.editTextValue);
        }
    }
}

