/*
 * Decompiled with CFR 0.152.
 */
package one.microproject.testmeter.impl;

import java.util.concurrent.Callable;
import one.microproject.testmeter.TestScenario;
import one.microproject.testmeter.dto.ScenarioRequest;
import one.microproject.testmeter.dto.ScenarioResult;
import one.microproject.testmeter.impl.ResultCache;

public class TestScenarioTask<T, R>
implements Callable<ScenarioResult<R>> {
    private final ScenarioRequest<T> request;
    private final ResultCache<T, R> resultCache;
    private final TestScenario<T, R> scenario;

    protected TestScenarioTask(ResultCache<T, R> resultCache, ScenarioRequest<T> request, TestScenario<T, R> scenario) {
        this.resultCache = resultCache;
        this.request = request;
        this.scenario = scenario;
    }

    @Override
    public ScenarioResult<R> call() throws Exception {
        long started = System.nanoTime();
        this.resultCache.onStarted(this.request);
        ScenarioResult<Object> scenarioResult = null;
        try {
            R result = this.scenario.getResult(this.request.getRequest());
            long duration = (System.nanoTime() - started) / 1000000L;
            scenarioResult = new ScenarioResult<R>(this.request.getId(), true, "OK", started / 1000000L, duration, result);
            this.resultCache.onResult(scenarioResult);
        }
        catch (Exception e) {
            long duration = (System.nanoTime() - started) / 1000000L;
            scenarioResult = new ScenarioResult<Object>(this.request.getId(), false, "ERROR: " + e.getMessage(), started / 1000000L, duration, null);
            this.resultCache.onResult(scenarioResult);
        }
        return scenarioResult;
    }
}

