/*
 * Decompiled with CFR 0.152.
 */
package no.oms.maven.precommit.lib;

import java.io.File;
import no.oms.maven.precommit.lib.BinaryInstaller;
import no.oms.maven.precommit.lib.BinaryRunner;
import no.oms.maven.precommit.lib.CacheResolver;
import no.oms.maven.precommit.lib.DefaultArchiveExtractor;
import no.oms.maven.precommit.lib.DefaultFileDownloader;
import no.oms.maven.precommit.lib.DefaultInstallConfig;
import no.oms.maven.precommit.lib.DefaultPythonHandle;
import no.oms.maven.precommit.lib.DirectoryCacheResolver;
import no.oms.maven.precommit.lib.InstallConfig;

public final class PluginFactory {
    private static final String DEFAULT_CACHE_PATH = "cache";
    private final File workingDirectory;
    private final File installDirectory;
    private final CacheResolver cacheResolver;

    public PluginFactory(File workingDirectory, File installDirectory) {
        this(workingDirectory, installDirectory, PluginFactory.getDefaultCacheResolver(installDirectory));
    }

    public PluginFactory(File workingDirectory, File installDirectory, CacheResolver cacheResolver) {
        this.workingDirectory = workingDirectory;
        this.installDirectory = installDirectory;
        this.cacheResolver = cacheResolver;
    }

    public BinaryInstaller getBinaryInstaller() {
        return new BinaryInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(), new DefaultPythonHandle());
    }

    public BinaryRunner getBinaryRunner() {
        return new BinaryRunner(this.getInstallConfig(), new DefaultPythonHandle());
    }

    private InstallConfig getInstallConfig() {
        return new DefaultInstallConfig(this.installDirectory, this.workingDirectory, this.cacheResolver);
    }

    private static final CacheResolver getDefaultCacheResolver(File root) {
        return new DirectoryCacheResolver(new File(root, DEFAULT_CACHE_PATH));
    }
}

