/*
 * Decompiled with CFR 0.152.
 */
package no.oms.maven.precommit.lib;

import java.io.File;
import no.oms.maven.precommit.lib.CacheDescriptor;
import no.oms.maven.precommit.lib.CacheResolver;

public class DirectoryCacheResolver
implements CacheResolver {
    private final File cacheDirectory;

    public DirectoryCacheResolver(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public File resolve(CacheDescriptor cacheDescriptor) {
        if (!this.cacheDirectory.exists()) {
            this.cacheDirectory.mkdirs();
        }
        StringBuilder filename = new StringBuilder().append(cacheDescriptor.getName()).append("-").append(cacheDescriptor.getVersion());
        if (cacheDescriptor.getClassifier() != null) {
            filename.append("-").append(cacheDescriptor.getClassifier());
        }
        filename.append(".").append(cacheDescriptor.getExtension());
        return new File(this.cacheDirectory, filename.toString());
    }
}

