/*
 * Decompiled with CFR 0.152.
 */
package no.oms.maven.precommit.lib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import no.oms.maven.precommit.lib.BackgroundStreamLogger;
import no.oms.maven.precommit.lib.HookType;
import no.oms.maven.precommit.lib.PythonException;
import no.oms.maven.precommit.lib.PythonHandle;
import no.oms.maven.precommit.lib.VirtualEnvDescriptor;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultPythonHandle
implements PythonHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonHandle.class);

    DefaultPythonHandle() {
    }

    @Override
    public VirtualEnvDescriptor setupVirtualEnv(File directory, String envName) throws PythonException {
        LOGGER.info("About to setup virtual env {}", (Object)envName);
        VirtualEnvDescriptor env = new VirtualEnvDescriptor(directory, envName);
        if (env.directory.exists()) {
            LOGGER.info("Virtual env already exists, skipping");
            return env;
        }
        String[] command = new String[]{this.getPython3Executable(), "-m", "venv", env.directory.getAbsolutePath()};
        LOGGER.debug("Running {}", (Object)command);
        try {
            Process child = Runtime.getRuntime().exec(command);
            int result = child.waitFor();
            String stdout = IOUtils.toString((InputStream)child.getInputStream());
            if (result != 0) {
                throw new PythonException("Could not create virtual env " + env.directory.getAbsolutePath() + ". return code " + result + "\nPython said: " + stdout);
            }
        }
        catch (IOException e) {
            throw new PythonException("Failed to execute python", e);
        }
        catch (InterruptedException e) {
            throw new PythonException("Unexpected interruption of while waiting for python virtualenv process", e);
        }
        return env;
    }

    @Override
    public void installPyYaml(VirtualEnvDescriptor env) throws PythonException {
        LOGGER.info("About to install pyyaml into env {}", (Object)env.name);
        if (!env.directory.exists()) {
            throw new PythonException("Virtual env " + env.name + " does not exist");
        }
        String[] command = new String[]{env.directory.getAbsolutePath() + "/bin/pip", "install", "pyyaml", "--disable-pip-version-check"};
        String[] environment = new String[]{"VIRTUAL_ENV=" + env.directory.getAbsolutePath()};
        LOGGER.debug("Running {} {} in {}", (Object)environment, (Object)command);
        try {
            Process child = Runtime.getRuntime().exec(command, environment);
            BackgroundStreamLogger errorGobbler = new BackgroundStreamLogger(child.getErrorStream(), "ERROR");
            BackgroundStreamLogger outputGobbler = new BackgroundStreamLogger(child.getInputStream(), "DEBUG");
            errorGobbler.start();
            outputGobbler.start();
            int result = child.waitFor();
            if (result != 0) {
                throw new PythonException("Failed to install pyyaml into " + env.name + ". return code " + result);
            }
        }
        catch (IOException e) {
            throw new PythonException("Failed to execute python", e);
        }
        catch (InterruptedException e) {
            throw new PythonException("Unexpected interruption of while waiting for python virtualenv process", e);
        }
        LOGGER.info("Successfully installed pyyaml into {}", (Object)env.name);
    }

    @Override
    public void installIntoVirtualEnv(VirtualEnvDescriptor env, File setupFile) throws PythonException {
        LOGGER.info("About to install binary into virtual env {}", (Object)env.name);
        if (!env.directory.exists()) {
            throw new PythonException("Virtual env " + env.name + " does not exist");
        }
        String[] command = new String[]{env.directory.getAbsolutePath() + "/bin/python", setupFile.getAbsolutePath(), "install"};
        String[] environment = new String[]{"VIRTUAL_ENV=" + env.directory.getAbsolutePath()};
        LOGGER.debug("Running {} {} in {}", new Object[]{environment, command, setupFile.getParentFile()});
        try {
            Process child = Runtime.getRuntime().exec(command, environment, setupFile.getParentFile());
            BackgroundStreamLogger errorGobbler = new BackgroundStreamLogger(child.getErrorStream(), "ERROR");
            BackgroundStreamLogger outputGobbler = new BackgroundStreamLogger(child.getInputStream(), "DEBUG");
            errorGobbler.start();
            outputGobbler.start();
            int result = child.waitFor();
            if (result != 0) {
                throw new PythonException("Failed to install into virtual env " + env.name + ". return code " + result);
            }
        }
        catch (IOException e) {
            throw new PythonException("Failed to execute python", e);
        }
        catch (InterruptedException e) {
            throw new PythonException("Unexpected interruption of while waiting for python virtualenv process", e);
        }
        LOGGER.info("Successfully installed into {}", (Object)env.name);
    }

    @Override
    public void installGitHooks(VirtualEnvDescriptor env, HookType[] hookTypes) throws PythonException {
        LOGGER.info("About to install commit hooks into virtual env {}", (Object)env.name);
        if (!env.directory.exists()) {
            throw new PythonException("Virtual env " + env.name + " does not exist");
        }
        if (hookTypes == null || hookTypes.length == 0) {
            throw new PythonException("Providing the hook types to install are required");
        }
        for (HookType type : hookTypes) {
            String[] command = new String[]{env.directory.getAbsolutePath() + "/bin/pre-commit", "install", "--install-hooks", "--overwrite", "--hook-type", type.getValue()};
            String[] environment = new String[]{"VIRTUAL_ENV=" + env.directory.getAbsolutePath(), "PATH=" + System.getenv("PATH")};
            LOGGER.debug("Running {} {}", (Object)environment, (Object)command);
            try {
                Process child = Runtime.getRuntime().exec(command, environment);
                BackgroundStreamLogger errorGobbler = new BackgroundStreamLogger(child.getErrorStream(), "ERROR");
                BackgroundStreamLogger outputGobbler = new BackgroundStreamLogger(child.getInputStream(), "INFO");
                errorGobbler.start();
                outputGobbler.start();
                int result = child.waitFor();
                if (result == 0) continue;
                throw new PythonException("Failed to install git hooks. return code " + result);
            }
            catch (IOException e) {
                throw new PythonException("Failed to execute python", e);
            }
            catch (InterruptedException e) {
                throw new PythonException("Unexpected interruption of while waiting for the pre-commit binary", e);
            }
        }
        LOGGER.info("Successfully installed Git commit hooks");
    }

    private String getPython3Executable() throws PythonException {
        if (this.binaryExists("python3")) {
            return "python3";
        }
        if (this.binaryExists("python")) {
            return "python";
        }
        throw new PythonException("Could not find a compatible python 3 version on your system. 3.3 is the minimum supported python version. Please check you have a compatible 'python' or 'python3' executable on your PATH");
    }

    private boolean binaryExists(String binaryName) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(new String[]{binaryName, "--version"});
            String output = IOUtils.toString((InputStream)proc.getInputStream());
            if (proc.waitFor() == 0 && this.checkVersion(output)) {
                LOGGER.debug("Located python binary `{}`", (Object)binaryName);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.debug("Did not locate a python binary called `{}`", (Object)binaryName);
        return false;
    }

    private boolean checkVersion(String pythonOutput) throws PythonException {
        try {
            String versionString = pythonOutput.split(" ")[1];
            int majorVersion = Integer.parseInt(versionString.split("\\.")[0]);
            int minorVersion = Integer.parseInt(versionString.split("\\.")[1]);
            return majorVersion >= 3 && minorVersion >= 3;
        }
        catch (Exception exception) {
            throw new PythonException("Unexpected python version output: " + pythonOutput, exception);
        }
    }
}

