/*
 * Decompiled with CFR 0.152.
 */
package no.oms.maven.precommit.lib;

import java.io.File;
import no.oms.maven.precommit.lib.CacheDescriptor;
import no.oms.maven.precommit.lib.CacheResolver;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepositoryManager;

public class RepositoryCacheResolver
implements CacheResolver {
    private static final String GROUP_ID = "no.oms.maven";
    private final RepositorySystemSession repositorySystemSession;

    public RepositoryCacheResolver(RepositorySystemSession repositorySystemSession) {
        this.repositorySystemSession = repositorySystemSession;
    }

    @Override
    public File resolve(CacheDescriptor cacheDescriptor) {
        LocalRepositoryManager manager = this.repositorySystemSession.getLocalRepositoryManager();
        File localArtifact = new File(manager.getRepository().getBasedir(), manager.getPathForLocalArtifact((Artifact)this.createArtifact(cacheDescriptor)));
        return localArtifact;
    }

    private DefaultArtifact createArtifact(CacheDescriptor cacheDescriptor) {
        String version = cacheDescriptor.getVersion().replaceAll("^v", "");
        DefaultArtifact artifact = cacheDescriptor.getClassifier() == null ? new DefaultArtifact(GROUP_ID, cacheDescriptor.getName(), cacheDescriptor.getExtension(), version) : new DefaultArtifact(GROUP_ID, cacheDescriptor.getName(), cacheDescriptor.getClassifier(), cacheDescriptor.getExtension(), version);
        return artifact;
    }
}

