/*
 * Decompiled with CFR 0.152.
 */
package no.oms.maven.precommit.lib;

import java.io.File;
import no.oms.maven.precommit.lib.HookType;
import no.oms.maven.precommit.lib.InstallConfig;
import no.oms.maven.precommit.lib.InstallationException;
import no.oms.maven.precommit.lib.PythonException;
import no.oms.maven.precommit.lib.PythonHandle;
import no.oms.maven.precommit.lib.VirtualEnvDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryRunner {
    public static final String INSTALL_PATH = "/pre-commit";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final PythonHandle pythonHandle;

    public BinaryRunner(InstallConfig config, PythonHandle pythonHandle) {
        this.config = config;
        this.pythonHandle = pythonHandle;
    }

    public void installHooks(HookType[] hookTypes) throws InstallationException {
        try {
            this.logger.info("Installing git commit hooks");
            File installDirectory = this.getInstallDirectory();
            VirtualEnvDescriptor env = this.pythonHandle.setupVirtualEnv(installDirectory, "pre-commit");
            this.pythonHandle.installGitHooks(env, hookTypes);
            this.logger.info("Installed Git commit hooks");
        }
        catch (PythonException e) {
            throw new InstallationException("Python encountered an issue when installing the pre-commit binary", e);
        }
    }

    private File getInstallDirectory() {
        File installDirectory = new File(this.config.getInstallDirectory(), INSTALL_PATH);
        if (!installDirectory.exists()) {
            this.logger.debug("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }
}

