/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.lookup;

import java.util.Map;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class StepLookup
extends Step {
    private final String lookupName;
    private final Map<String, String> lookup;
    private final String defaultValue;

    public StepLookup(String lookupName, Map<String, String> lookup, String defaultValue) {
        this.lookupName = lookupName;
        this.lookup = lookup;
        this.defaultValue = defaultValue;
    }

    @Override
    public String walk(ParseTree tree, String value) {
        String input = this.getActualValue(tree, value);
        String result = this.lookup.get(input.toLowerCase());
        if (result == null) {
            if (this.defaultValue == null) {
                return null;
            }
            return this.walkNextStep(tree, this.defaultValue);
        }
        return this.walkNextStep(tree, result);
    }

    public String toString() {
        return "Lookup(@" + this.lookupName + " ; default=" + this.defaultValue + ")";
    }
}

