/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.pig.input.apachehttpdlog;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import nl.basjes.hadoop.input.ApacheHttpdLogfileInputFormat;
import nl.basjes.hadoop.input.ApacheHttpdLogfileRecordReader;
import nl.basjes.hadoop.input.ParsedRecord;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.pig.input.apachehttpdlog.IncorrectRecordReaderException;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader
extends LoadFunc
implements LoadMetadata,
LoadPushDown {
    private static final Logger LOG = LoggerFactory.getLogger(Loader.class);
    private ApacheHttpdLogfileRecordReader reader;
    private boolean onlyWantListOfFields = false;
    private boolean isBuildingExample = false;
    private String logformat;
    private List<String> requestedFields = new ArrayList<String>();
    private List<String> originalRequestedFields = null;
    private LoadPushDown.RequiredFieldList requiredFieldList = null;
    private final Map<String, Set<String>> typeRemappings = new HashMap<String, Set<String>>();
    private final List<Dissector> additionalDissectors = new ArrayList<Dissector>();
    private final TupleFactory tupleFactory;
    private final ApacheHttpdLogfileInputFormat theInputFormat;
    private final ArrayList<String> specialParameters = new ArrayList();
    private static final String PRUNE_PROJECTION_INFO = "prune.projection.info";
    private static final String MULTI_COMMENT = "  -- If you only want a single field replace * with name and change type to chararray";
    private String theUDFContextSignature;

    public Loader(String ... parameters) {
        for (String param : parameters) {
            if (this.logformat == null) {
                this.logformat = param;
                LOG.debug("Using logformat: {}", (Object)this.logformat);
                continue;
            }
            if (param.startsWith("-map:")) {
                this.specialParameters.add(param);
                String[] mapParams = param.split(":");
                if (mapParams.length != 3) {
                    throw new IllegalArgumentException("Found map with wrong number of parameters:" + param);
                }
                String mapField = mapParams[1];
                String mapType = mapParams[2];
                Set remapping = this.typeRemappings.computeIfAbsent(mapField, k -> new HashSet());
                remapping.add(mapType);
                LOG.debug("Add mapping for field \"{}\" to type \"{}\"", (Object)mapField, (Object)mapType);
                continue;
            }
            if (param.startsWith("-load:")) {
                this.specialParameters.add(param);
                String[] loadParams = param.split(":", 3);
                if (loadParams.length != 3) {
                    throw new IllegalArgumentException("Found load with wrong number of parameters:" + param);
                }
                String dissectorClassName = loadParams[1];
                String dissectorParam = loadParams[2];
                try {
                    Class<?> clazz = Class.forName(dissectorClassName);
                    Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                    Dissector instance = (Dissector)constructor.newInstance(new Object[0]);
                    if (!instance.initializeFromSettingsParameter(dissectorParam)) {
                        throw new IllegalArgumentException("Initialization failed of dissector instance of class " + dissectorClassName);
                    }
                    this.additionalDissectors.add(instance);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Found load with bad specification: No such class:" + param, e);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Found load with bad specification: Class does not have the required constructor", e);
                }
                catch (InstantiationException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Unable to load specified dissector", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Found load with bad specification: Required constructor is not public", e);
                }
                LOG.debug("Loaded additional dissector: {}(\"{}\")", (Object)dissectorClassName, (Object)dissectorParam);
                continue;
            }
            if ("fields".equals(param.toLowerCase(Locale.ENGLISH))) {
                this.onlyWantListOfFields = true;
                this.requestedFields.add("fields");
                LOG.debug("Requested ONLY the possible field values");
                continue;
            }
            if ("example".equals(param.toLowerCase(Locale.ENGLISH))) {
                this.isBuildingExample = true;
                this.requestedFields.add("fields");
                LOG.debug("Requested ONLY the possible field values in EXAMPLE format");
                continue;
            }
            String cleanedFieldValue = Parser.cleanupFieldValue((String)param);
            LOG.debug("Add Requested field: {} ", (Object)cleanedFieldValue);
            this.requestedFields.add(cleanedFieldValue);
        }
        if (this.logformat == null) {
            throw new IllegalArgumentException("Must specify the logformat");
        }
        if (this.requestedFields.isEmpty()) {
            this.isBuildingExample = true;
            this.requestedFields.add("fields");
            LOG.debug("Requested ONLY the possible field values in EXAMPLE format");
        }
        this.theInputFormat = new ApacheHttpdLogfileInputFormat(this.getLogformat(), this.getRequestedFields(), this.getTypeRemappings(), this.getAdditionalDissectors());
        this.reader = this.theInputFormat.getRecordReader();
        this.tupleFactory = TupleFactory.getInstance();
    }

    public InputFormat<?, ?> getInputFormat() {
        return this.theInputFormat;
    }

    public final String getLogformat() {
        return this.logformat;
    }

    public final List<String> getRequestedFields() {
        return this.requestedFields;
    }

    public Tuple getNext() throws IOException {
        Tuple tuple = null;
        try {
            if (this.isBuildingExample) {
                this.isBuildingExample = false;
                return this.tupleFactory.newTuple((Object)this.createPigExample());
            }
            boolean notDone = this.reader.nextKeyValue();
            if (!notDone) {
                return null;
            }
            ParsedRecord value = this.reader.getCurrentValue();
            if (value != null) {
                ArrayList<Object> values = new ArrayList<Object>();
                if (this.onlyWantListOfFields) {
                    values.add(value.getString("fields"));
                } else {
                    for (String fieldName : this.requestedFields) {
                        if (fieldName.endsWith(".*")) {
                            values.add(value.getStringSet(fieldName));
                            continue;
                        }
                        EnumSet casts = this.reader.getParser().getCasts(fieldName);
                        if (casts != null) {
                            if (casts.contains(Casts.LONG)) {
                                values.add(value.getLong(fieldName));
                                continue;
                            }
                            if (casts.contains(Casts.DOUBLE)) {
                                values.add(value.getDouble(fieldName));
                                continue;
                            }
                        }
                        values.add(value.getString(fieldName));
                    }
                }
                tuple = this.tupleFactory.newTuple(values);
            }
        }
        catch (InvalidDissectorException | MissingDissectorsException e) {
            throw new IOException("Fatal error in the parser", e);
        }
        return tuple;
    }

    private String createPigExample() throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        String fieldName = this.requestedFields.get(0);
        ArrayList<String> fields = new ArrayList<String>(128);
        ArrayList<String> names = new ArrayList<String>(128);
        while (this.reader.nextKeyValue()) {
            ParsedRecord currentValue = this.reader.getCurrentValue();
            String value = currentValue.getString(fieldName);
            if (value == null) continue;
            if (value.contains("*")) {
                fields.add(value + "'," + MULTI_COMMENT);
            } else {
                fields.add(value);
            }
            String name = value.split(":")[1].replace('.', '_').replace('-', '_').replace('*', '_');
            EnumSet casts = this.reader.getCasts(value);
            String cast = "bytearray";
            if (casts != null) {
                if (casts.contains(Casts.LONG)) {
                    cast = "long";
                } else if (casts.contains(Casts.DOUBLE)) {
                    cast = "double";
                } else if (casts.contains(Casts.STRING)) {
                    cast = "chararray";
                    if (value.contains("*")) {
                        cast = "map[],  -- If you only want a single field replace * with name and change type to chararray";
                    }
                }
                names.add(name + ':' + cast);
                continue;
            }
            names.add(name);
        }
        sb.append("\n").append("\n").append("\n").append("Clicks =\n").append("    LOAD 'access.log'\n").append("    USING ").append(((Object)((Object)this)).getClass().getCanonicalName()).append("(\n").append("        '").append(this.logformat).append("',\n").append('\n');
        if (!this.specialParameters.isEmpty()) {
            sb.append("        '").append(Loader.join(this.specialParameters, (String)"',\n        '")).append("',\n");
        }
        sb.append("        '").append(Loader.join(fields, (String)"',\n        '")).append("')\n").append("    AS (\n").append("        ").append(Loader.join(names, (String)",\n        ")).append(");\n").append("\n").append("\n").append("\n");
        return sb.toString();
    }

    public void prepareToRead(RecordReader newReader, PigSplit pigSplit) {
        if (!(newReader instanceof ApacheHttpdLogfileRecordReader)) {
            throw new IncorrectRecordReaderException();
        }
        this.reader = (ApacheHttpdLogfileRecordReader)newReader;
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
        this.requiredFieldList = (LoadPushDown.RequiredFieldList)this.getFromUDFContext(PRUNE_PROJECTION_INFO);
        if (this.requiredFieldList != null && this.originalRequestedFields == null) {
            HashSet<Integer> requestedFieldIndexes = new HashSet<Integer>();
            for (LoadPushDown.RequiredField requiredField : this.requiredFieldList.getFields()) {
                requestedFieldIndexes.add(requiredField.getIndex());
            }
            ArrayList<String> prunedRequestedFields = new ArrayList<String>(requestedFieldIndexes.size());
            int index = 0;
            for (String field : this.requestedFields) {
                if (requestedFieldIndexes.contains(index)) {
                    prunedRequestedFields.add(field);
                }
                ++index;
            }
            this.originalRequestedFields = this.requestedFields;
            this.requestedFields = prunedRequestedFields;
        }
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        ResourceSchema rs = new ResourceSchema();
        ArrayList<ResourceSchema.ResourceFieldSchema> fieldSchemaList = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        for (String fieldName : this.requestedFields) {
            ResourceSchema.ResourceFieldSchema rfs = new ResourceSchema.ResourceFieldSchema();
            rfs.setName(fieldName);
            rfs.setDescription(fieldName);
            if (fieldName.endsWith(".*")) {
                rfs.setType((byte)100);
            } else {
                EnumSet casts = this.theInputFormat.getRecordReader().getCasts(fieldName);
                if (casts != null) {
                    if (casts.contains(Casts.LONG)) {
                        rfs.setType((byte)15);
                    } else if (casts.contains(Casts.DOUBLE)) {
                        rfs.setType((byte)25);
                    } else {
                        rfs.setType((byte)55);
                    }
                } else {
                    rfs.setType((byte)50);
                }
            }
            fieldSchemaList.add(rfs);
        }
        rs.setFields(fieldSchemaList.toArray(new ResourceSchema.ResourceFieldSchema[fieldSchemaList.size()]));
        return rs;
    }

    public ResourceStatistics getStatistics(String location, Job job) {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) {
    }

    public final Map<String, Set<String>> getTypeRemappings() {
        return this.typeRemappings;
    }

    public List<Dissector> getAdditionalDissectors() {
        return this.additionalDissectors;
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Collections.singletonList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList pRequiredFieldList) {
        this.requiredFieldList = pRequiredFieldList;
        this.storeInUDFContext(PRUNE_PROJECTION_INFO, this.requiredFieldList);
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public void setUDFContextSignature(String signature) {
        this.theUDFContextSignature = signature;
    }

    private void storeInUDFContext(String key, Object value) {
        UDFContext udfContext = UDFContext.getUDFContext();
        Properties props = udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.theUDFContextSignature});
        props.put(key, value);
    }

    private Object getFromUDFContext(String key) {
        UDFContext udfContext = UDFContext.getUDFContext();
        Properties udfProperties = udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.theUDFContextSignature});
        return udfProperties.get(key);
    }
}

