/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.http.disectors;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Disector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;

public class ResponseSetCookieListDisector
extends Disector {
    private static final String INPUT_TYPE = "HTTP.SETCOOKIES";
    private final Set<String> requestedCookies = new HashSet<String>(16);
    private boolean wantAllCookies = false;
    private final int minimalExpiresLength = "expires=XXXXXXX".length();
    private final String splitBy = ", ";
    private final Pattern fieldSeparatorPattern = Pattern.compile(", ");

    @Override
    public String getInputType() {
        return INPUT_TYPE;
    }

    @Override
    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.SETCOOKIE:*");
        return result;
    }

    @Override
    protected void initializeNewInstance(Disector newInstance) {
    }

    @Override
    public EnumSet<Casts> prepareForDisect(String inputname, String outputname) {
        this.requestedCookies.add(outputname.substring(inputname.length() + 1));
        return Casts.STRING_ONLY;
    }

    @Override
    public void prepareForRun() {
        this.wantAllCookies = this.requestedCookies.contains("*");
    }

    @Override
    public void disect(Parsable<?> parsable, String inputname) {
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        String[] parts = this.fieldSeparatorPattern.split(fieldValue);
        String previous = "";
        for (String part : parts) {
            int expiresIndex = part.toLowerCase().indexOf("expires=");
            if (expiresIndex != -1 && part.length() - this.minimalExpiresLength < expiresIndex) {
                previous = part;
                continue;
            }
            String value = part;
            if (!previous.isEmpty()) {
                value = previous + ", " + part;
                previous = "";
            }
            List<HttpCookie> cookies = HttpCookie.parse(value);
            for (HttpCookie cookie : cookies) {
                cookie.setVersion(1);
                String cookieName = cookie.getName().toLowerCase();
                if (!this.wantAllCookies && !this.requestedCookies.contains(cookieName)) continue;
                parsable.addDisection(inputname, this.getDisectionType(inputname, cookieName), cookieName, value);
            }
        }
    }

    public String getDisectionType(String basename, String name) {
        return "HTTP.SETCOOKIE";
    }
}

