/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.http.disectors;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Disector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;

public class ResponseSetCookieDisector
extends Disector {
    private static final String INPUT_TYPE = "HTTP.SETCOOKIE";

    @Override
    public String getInputType() {
        return INPUT_TYPE;
    }

    @Override
    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("STRING:value");
        result.add("STRING:expires");
        result.add("STRING:path");
        result.add("STRING:domain");
        return result;
    }

    @Override
    protected void initializeNewInstance(Disector newInstance) {
    }

    @Override
    public EnumSet<Casts> prepareForDisect(String inputname, String outputname) {
        return Casts.STRING_ONLY;
    }

    @Override
    public void prepareForRun() {
    }

    @Override
    public void disect(Parsable<?> parsable, String inputname) {
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        Long nowSeconds = System.currentTimeMillis() / 1000L;
        List<HttpCookie> cookies = HttpCookie.parse(fieldValue);
        for (HttpCookie cookie : cookies) {
            parsable.addDisection(inputname, this.getDisectionType(inputname, "value"), "value", cookie.getValue());
            parsable.addDisection(inputname, this.getDisectionType(inputname, "expires"), "expires", Long.toString(nowSeconds + cookie.getMaxAge()));
            parsable.addDisection(inputname, this.getDisectionType(inputname, "path"), "path", cookie.getPath());
            parsable.addDisection(inputname, this.getDisectionType(inputname, "domain"), "domain", cookie.getDomain());
            parsable.addDisection(inputname, this.getDisectionType(inputname, "comment"), "comment", cookie.getComment());
        }
    }

    public String getDisectionType(String basename, String name) {
        return "STRING";
    }
}

