/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.http.disectors;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Disector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DisectionFailure;

public class HttpUriDisector
extends Disector {
    private static final String INPUT_TYPE = "HTTP.URI";
    private boolean wantProtocol = false;
    private boolean wantUserinfo = false;
    private boolean wantHost = false;
    private boolean wantPort = false;
    private boolean wantPath = false;
    private boolean wantQuery = false;
    private boolean wantRef = false;

    @Override
    public String getInputType() {
        return INPUT_TYPE;
    }

    @Override
    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.PROTOCOL:protocol");
        result.add("HTTP.USERINFO:userinfo");
        result.add("HTTP.HOST:host");
        result.add("HTTP.PORT:port");
        result.add("HTTP.PATH:path");
        result.add("HTTP.QUERYSTRING:query");
        result.add("HTTP.REF:ref");
        return result;
    }

    @Override
    protected void initializeNewInstance(Disector newInstance) {
    }

    @Override
    public EnumSet<Casts> prepareForDisect(String inputname, String outputname) {
        String name = outputname.substring(inputname.length() + 1);
        if ("protocol".equals(name)) {
            this.wantProtocol = true;
            return Casts.STRING_ONLY;
        }
        if ("userinfo".equals(name)) {
            this.wantUserinfo = true;
            return Casts.STRING_ONLY;
        }
        if ("host".equals(name)) {
            this.wantHost = true;
            return Casts.STRING_ONLY;
        }
        if ("port".equals(name)) {
            this.wantPort = true;
            return Casts.STRING_OR_LONG;
        }
        if ("path".equals(name)) {
            this.wantPath = true;
            return Casts.STRING_ONLY;
        }
        if ("query".equals(name)) {
            this.wantQuery = true;
            return Casts.STRING_ONLY;
        }
        if ("ref".equals(name)) {
            this.wantRef = true;
            return Casts.STRING_ONLY;
        }
        return null;
    }

    @Override
    public void prepareForRun() {
    }

    @Override
    public void disect(Parsable<?> parsable, String inputname) throws DisectionFailure {
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        int questionMark = fieldValue.indexOf(63);
        int firstAmpersand = fieldValue.indexOf(38);
        if (this.wantQuery || this.wantPath || this.wantRef) {
            String refValue;
            String queryValue;
            String pathValue;
            if (questionMark == -1) {
                if (firstAmpersand == -1) {
                    pathValue = fieldValue;
                    queryValue = "";
                } else {
                    pathValue = fieldValue.substring(0, firstAmpersand);
                    queryValue = fieldValue.substring(firstAmpersand, fieldValue.length());
                }
            } else if (firstAmpersand == -1) {
                pathValue = fieldValue.substring(0, questionMark);
                queryValue = "&" + fieldValue.substring(questionMark + 1, fieldValue.length());
            } else {
                int usedOffset = Math.min(questionMark, firstAmpersand);
                pathValue = fieldValue.substring(0, usedOffset);
                queryValue = "&" + fieldValue.substring(usedOffset + 1, fieldValue.length()).replaceAll("\\?", "&");
            }
            int hashMark = queryValue.indexOf(35);
            if (hashMark != -1) {
                refValue = queryValue.substring(hashMark + 1);
                queryValue = queryValue.substring(0, hashMark);
            } else {
                refValue = "";
            }
            if (this.wantQuery) {
                parsable.addDisection(inputname, "HTTP.QUERYSTRING", "query", queryValue);
            }
            if (this.wantPath) {
                parsable.addDisection(inputname, "HTTP.PATH", "path", pathValue);
            }
            if (this.wantRef) {
                parsable.addDisection(inputname, "HTTP.REF", "ref", refValue);
            }
        }
        if (this.wantProtocol || this.wantUserinfo || this.wantHost || this.wantPort) {
            URI uri;
            try {
                uri = new URI(fieldValue);
            }
            catch (URISyntaxException e) {
                throw new DisectionFailure("Unable to parse the URI: >>>" + fieldValue + "<<< (" + e.getMessage() + ")");
            }
            if (this.wantProtocol) {
                parsable.addDisection(inputname, "HTTP.PROTOCOL", "protocol", uri.getRawSchemeSpecificPart());
            }
            if (this.wantUserinfo) {
                parsable.addDisection(inputname, "HTTP.USERINFO", "userinfo", uri.getUserInfo());
            }
            if (this.wantHost) {
                parsable.addDisection(inputname, "HTTP.HOST", "host", uri.getHost());
            }
            if (this.wantPort && uri.getPort() != -1) {
                parsable.addDisection(inputname, "HTTP.PORT", "port", String.valueOf(uri.getPort()));
            }
        }
    }
}

