/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.tokenformat;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.Token;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenOutputField;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenSorterByStartPos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TokenFormatDissector
extends Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(TokenFormatDissector.class);
    private String logFormat = null;
    private ArrayList<Token> logFormatUsedTokens = null;
    private String logFormatRegEx = null;
    private Pattern logFormatPattern = null;
    private boolean isUsable = false;
    private List<Token> logFormatTokens;
    private List<String> outputTypes;
    private final Set<String> requestedFields = new HashSet<String>(16);
    private String inputType = null;

    public TokenFormatDissector(String logFormat) {
        this.setLogFormat(logFormat);
    }

    public TokenFormatDissector() {
    }

    public boolean initializeFromSettingsParameter(String settings) {
        this.setLogFormat(this.logFormat);
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
        if (newInstance instanceof TokenFormatDissector) {
            ((TokenFormatDissector)newInstance).setLogFormat(this.logFormat);
        } else {
            LOG.error("============================== WTF == {}", (Object)newInstance.getClass().getCanonicalName());
        }
    }

    public void setLogFormat(String logformat) {
        this.logFormat = logformat;
        this.logFormatTokens = this.parseTokenLogFileDefinition(this.logFormat);
        this.outputTypes = new ArrayList<String>();
        for (Token token : this.logFormatTokens) {
            List<TokenOutputField> outputFields;
            if (token instanceof FixedStringToken || (outputFields = token.getOutputFields()).isEmpty()) continue;
            for (TokenOutputField tokenOutputField : outputFields) {
                this.outputTypes.add(tokenOutputField.getType() + ":" + tokenOutputField.getName());
            }
        }
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public String getLogFormatRegEx() {
        return this.logFormatRegEx;
    }

    public EnumSet<Casts> prepareForDissect(String inputName, String outputName) {
        this.requestedFields.add(outputName);
        for (Token token : this.logFormatTokens) {
            for (TokenOutputField tokenOutputField : token.getOutputFields()) {
                if (!outputName.equals(tokenOutputField.getName())) continue;
                tokenOutputField.wasUsed();
                return tokenOutputField.getCasts();
            }
        }
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() {
        StringBuilder regex = new StringBuilder(this.logFormatTokens.size() * 16);
        this.logFormatUsedTokens = new ArrayList();
        regex.append('^');
        for (Token token : this.logFormatTokens) {
            token.tokenWasUsed();
            if (token instanceof FixedStringToken) {
                regex.append(Pattern.quote(token.getRegex()));
                continue;
            }
            if (token.canProduceADesiredFieldName(this.requestedFields)) {
                this.logFormatUsedTokens.add(token);
                regex.append("(").append(token.getRegex()).append(")");
                continue;
            }
            regex.append("(?:").append(token.getRegex()).append(")");
        }
        regex.append('$');
        this.logFormatRegEx = regex.toString();
        LOG.debug("Source logformat : {}", (Object)this.logFormat);
        LOG.debug("Used regex       : {}", (Object)this.logFormatRegEx);
        this.logFormatPattern = Pattern.compile(this.logFormatRegEx);
        this.isUsable = true;
    }

    public void setInputType(String newInputType) {
        this.inputType = newInputType;
    }

    public String getInputType() {
        return this.inputType;
    }

    public List<String> getPossibleOutput() {
        return this.outputTypes;
    }

    public abstract String decodeExtractedValue(String var1, String var2);

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        if (!this.isUsable) {
            throw new DissectionFailure("Dissector in unusable state");
        }
        ParsedField line = parsable.getParsableField(this.inputType, inputname);
        Matcher matcher = this.logFormatPattern.matcher(line.getValue().getString());
        boolean matches = matcher.find();
        if (matches) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String matchedStr = matcher.group(i);
                Token token = this.logFormatUsedTokens.get(i - 1);
                for (TokenOutputField tokenOutputField : token.getOutputFields()) {
                    String matchedName = tokenOutputField.getName();
                    String matchedType = tokenOutputField.getType();
                    parsable.addDissection(inputname, matchedType, matchedName, this.decodeExtractedValue(matchedName, matchedStr));
                }
            }
        } else {
            throw new DissectionFailure("The input line does not match the specified log format.Line     : " + String.valueOf(line.getValue()) + "\nLogFormat: " + this.logFormat + "\nRegEx    : " + this.logFormatRegEx);
        }
    }

    protected String cleanupLogFormat(String tokenLogFormat) {
        return tokenLogFormat;
    }

    private List<Token> parseTokenLogFileDefinition(String tokenLogFormat) {
        List<TokenParser> tokenParsers = this.createAllTokenParsers();
        ArrayList<Token> tokens = new ArrayList<Token>(50);
        String cleanedTokenLogFormat = this.cleanupLogFormat(tokenLogFormat);
        for (TokenParser tokenParser : tokenParsers) {
            List<Token> newTokens = tokenParser.getTokens(cleanedTokenLogFormat);
            if (newTokens == null) continue;
            tokens.addAll(newTokens);
        }
        tokens.sort(new TokenSorterByStartPos());
        ArrayList<Token> kickTokens = new ArrayList<Token>(50);
        Token prevToken = null;
        for (Token token : tokens) {
            if (prevToken == null) {
                prevToken = token;
                continue;
            }
            if (prevToken.getStartPos() == token.getStartPos()) {
                if (prevToken.getLength() == token.getLength()) {
                    if (prevToken.getPrio() < token.getPrio()) {
                        kickTokens.add(prevToken);
                    } else {
                        kickTokens.add(token);
                    }
                } else if (prevToken.getLength() < token.getLength()) {
                    kickTokens.add(prevToken);
                } else {
                    kickTokens.add(token);
                }
            } else if (prevToken.getStartPos() + prevToken.getLength() > token.getStartPos()) {
                kickTokens.add(token);
                continue;
            }
            prevToken = token;
        }
        tokens.removeAll(kickTokens);
        ArrayList<Token> allTokens = new ArrayList<Token>(50);
        int tokenEnd = 0;
        for (Token token : tokens) {
            int tokenBegin = token.getStartPos();
            if (tokenBegin - tokenEnd > 0) {
                String separator = cleanedTokenLogFormat.substring(tokenEnd, tokenBegin);
                FixedStringToken fixedStringToken = new FixedStringToken(separator, tokenBegin, tokenBegin - tokenEnd, 0);
                allTokens.add(fixedStringToken);
            }
            allTokens.add(token);
            tokenEnd = tokenBegin + token.getLength();
        }
        int logFormatLength = cleanedTokenLogFormat.length();
        if (tokenEnd < logFormatLength) {
            String separator = cleanedTokenLogFormat.substring(tokenEnd);
            FixedStringToken fixedStringToken = new FixedStringToken(separator, tokenEnd, cleanedTokenLogFormat.length() - tokenEnd, 0);
            allTokens.add(fixedStringToken);
        }
        return allTokens;
    }

    public <RECORD> void createAdditionalDissectors(Parser<RECORD> parser) {
        for (Token token : this.logFormatTokens) {
            parser.addDissector(token.getCustomDissector());
        }
    }

    protected abstract List<TokenParser> createAllTokenParsers();

    public static class FixedStringToken
    extends Token {
        public FixedStringToken(String nRegex, int nStartPos, int nLength, int nPrio) {
            super(nRegex, nStartPos, nLength, nPrio);
        }
    }

    public static class NotImplementedTokenParser
    extends TokenParser {
        public NotImplementedTokenParser(String nLogFormatToken, String fieldPrefix, int nPrio) {
            this(nLogFormatToken, fieldPrefix, ".*", nPrio);
        }

        public NotImplementedTokenParser(String nLogFormatToken, String fieldPrefix, String regEx, int nPrio) {
            super(nLogFormatToken, fieldPrefix + "_" + nLogFormatToken.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9_]", "_"), "NOT_IMPLEMENTED", Casts.STRING_ONLY, regEx, nPrio);
        }
    }

    public static class FixedStringTokenParser
    extends TokenParser {
        public FixedStringTokenParser(String nLogFormatToken, String nRegEx) {
            super(nLogFormatToken, nRegEx, 0);
        }

        @Override
        public Token getNextToken(String logFormat, int startOffset) {
            int pos = logFormat.indexOf(this.getLogFormatToken(), startOffset);
            if (pos == -1) {
                return null;
            }
            return new FixedStringToken(this.getRegex(), pos, this.getLogFormatToken().length(), 0).addOutputFields(this.getOutputFields());
        }
    }
}

