/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.geoip;

import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.IspResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.dissectors.geoip.GeoIPASNDissector;

public class GeoIPISPDissector
extends GeoIPASNDissector {
    private boolean wantIspName = false;
    private boolean wantIspOrganization = false;

    public GeoIPISPDissector() {
    }

    public GeoIPISPDissector(String databaseFileName) {
        super(databaseFileName);
    }

    @Override
    public List<String> getPossibleOutput() {
        List<String> result = super.getPossibleOutput();
        result.add("STRING:isp.name");
        result.add("STRING:isp.organization");
        return result;
    }

    @Override
    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name;
        EnumSet<Casts> result = super.prepareForDissect(inputname, outputname);
        if (!result.isEmpty()) {
            return result;
        }
        switch (name = this.extractFieldName(inputname, outputname)) {
            case "isp.name": {
                this.wantIspName = true;
                return Casts.STRING_ONLY;
            }
            case "isp.organization": {
                this.wantIspOrganization = true;
                return Casts.STRING_ONLY;
            }
        }
        return Casts.NO_CASTS;
    }

    @Override
    public void dissect(Parsable<?> parsable, String inputname, InetAddress ipAddress) throws DissectionFailure {
        IspResponse response;
        try {
            response = this.reader.isp(ipAddress);
        }
        catch (GeoIp2Exception | IOException e) {
            return;
        }
        this.extractAsnFields(parsable, inputname, response);
        this.extractIspFields(parsable, inputname, response);
    }

    protected void extractIspFields(Parsable<?> parsable, String inputname, IspResponse response) throws DissectionFailure {
        if (this.wantIspName) {
            parsable.addDissection(inputname, "STRING", "isp.name", response.isp());
        }
        if (this.wantIspOrganization) {
            parsable.addDissection(inputname, "STRING", "isp.organization", response.organization());
        }
    }
}

