/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.nginxmodules;

import java.util.ArrayList;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.NginxModule;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.UpstreamListDissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.NamedTokenParser;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;

public class UpstreamModule
implements NginxModule {
    private static final String PREFIX = "nginxmodule.upstream";

    private String upstreamListOf(String regex) {
        return regex + "(?: *, *" + regex + "(?: *: *" + regex + ")?)*";
    }

    @Override
    public List<TokenParser> getTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(60);
        parsers.add(new TokenParser("$upstream_addr", "nginxmodule.upstream.addr", "UPSTREAM_ADDR_LIST", Casts.STRING_ONLY, this.upstreamListOf("[^\\s]*")));
        parsers.add(new TokenParser("$upstream_bytes_received", "nginxmodule.upstream.bytes.received", "UPSTREAM_BYTES_LIST", Casts.STRING_ONLY, this.upstreamListOf("[0-9]+")));
        parsers.add(new TokenParser("$upstream_bytes_sent", "nginxmodule.upstream.bytes.sent", "UPSTREAM_BYTES_LIST", Casts.STRING_ONLY, this.upstreamListOf("[0-9]+")));
        parsers.add(new TokenParser("$upstream_cache_status", "nginxmodule.upstream.cache.status", "UPSTREAM_CACHE_STATUS", Casts.STRING_ONLY, "(?:MISS|BYPASS|EXPIRED|STALE|UPDATING|REVALIDATED|HIT)"));
        parsers.add(new TokenParser("$upstream_connect_time", "nginxmodule.upstream.connect.time", "UPSTREAM_SECOND_MILLIS_LIST", Casts.STRING_ONLY, this.upstreamListOf("[0-9]+\\.[0-9]+")));
        parsers.add(new NamedTokenParser("\\$upstream_cookie_([a-z0-9\\-_]*)", "nginxmodule.upstream.response.cookies.", "HTTP.COOKIE", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$upstream_header_time", "nginxmodule.upstream.header.time", "UPSTREAM_SECOND_MILLIS_LIST", Casts.STRING_ONLY, this.upstreamListOf("[0-9]+\\.[0-9]+")));
        parsers.add(new NamedTokenParser("\\$upstream_http_([a-z0-9\\-_]*)", "nginxmodule.upstream.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$upstream_queue_time", "nginxmodule.upstream.queue.time", "UPSTREAM_SECOND_MILLIS_LIST", Casts.STRING_ONLY, this.upstreamListOf("[0-9]+\\.[0-9]+")));
        parsers.add(new TokenParser("$upstream_response_length", "nginxmodule.upstream.response.length", "UPSTREAM_BYTES_LIST", Casts.STRING_ONLY, this.upstreamListOf("[0-9]+")));
        parsers.add(new TokenParser("$upstream_response_time", "nginxmodule.upstream.response.time", "UPSTREAM_SECOND_MILLIS_LIST", Casts.STRING_ONLY, this.upstreamListOf("[0-9]+\\.[0-9]+")));
        parsers.add(new TokenParser("$upstream_status", "nginxmodule.upstream.status", "UPSTREAM_STATUS_LIST", Casts.STRING_ONLY, this.upstreamListOf("[^\\s]*")));
        parsers.add(new NamedTokenParser("\\$upstream_trailer_([a-z0-9\\-_]*)", "nginxmodule.upstream.trailer.", "HTTP.TRAILER", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$upstream_first_byte_time", "nginxmodule.upstream.first_byte.time", "UPSTREAM_SECOND_MILLIS_LIST", Casts.STRING_ONLY, this.upstreamListOf("[0-9]+\\.[0-9]+")));
        parsers.add(new TokenParser("$upstream_session_time", "nginxmodule.upstream.session.time", "UPSTREAM_SECOND_MILLIS_LIST", Casts.STRING_ONLY, this.upstreamListOf("[0-9]+\\.[0-9]+")));
        return parsers;
    }

    @Override
    public List<Dissector> getDissectors() {
        ArrayList<Dissector> dissectors = new ArrayList<Dissector>();
        dissectors.add(new UpstreamListDissector("UPSTREAM_ADDR_LIST", "UPSTREAM_ADDR", Casts.STRING_ONLY, "UPSTREAM_ADDR", Casts.STRING_ONLY));
        dissectors.add(new UpstreamListDissector("UPSTREAM_BYTES_LIST", "BYTES", Casts.STRING_OR_LONG, "BYTES", Casts.STRING_OR_LONG));
        dissectors.add(new UpstreamListDissector("UPSTREAM_SECOND_MILLIS_LIST", "SECOND_MILLIS", Casts.STRING_OR_LONG_OR_DOUBLE, "SECOND_MILLIS", Casts.STRING_OR_LONG_OR_DOUBLE));
        dissectors.add(new UpstreamListDissector("UPSTREAM_STATUS_LIST", "UPSTREAM_STATUS", Casts.STRING_ONLY, "UPSTREAM_STATUS", Casts.STRING_ONLY));
        return dissectors;
    }
}

