/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public final class Utils {
    private static final Pattern VALID_STANDARD = Pattern.compile("%([0-9A-Fa-f]{2})");
    private static final Pattern CHOPPED_STANDARD = Pattern.compile("%[0-9A-Fa-f]?$");
    private static final Pattern VALID_NON_STANDARD = Pattern.compile("%u([0-9A-Fa-f][0-9A-Fa-f])([0-9A-Fa-f][0-9A-Fa-f])");
    private static final Pattern CHOPPED_NON_STANDARD = Pattern.compile("%u[0-9A-Fa-f]{0,3}$");

    private Utils() {
    }

    public static String resilientUrlDecode(String input) {
        String cookedInput = input;
        if (cookedInput.indexOf(37) > -1) {
            cookedInput = VALID_STANDARD.matcher(cookedInput).replaceAll("%00%$1");
            if ((cookedInput = CHOPPED_STANDARD.matcher(cookedInput).replaceAll("")).contains("%u")) {
                cookedInput = VALID_NON_STANDARD.matcher(cookedInput).replaceAll("%$1%$2");
                cookedInput = CHOPPED_NON_STANDARD.matcher(cookedInput).replaceAll("");
            }
        }
        try {
            return URLDecoder.decode(cookedInput, "UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte hexCharsToByte(String twoHexDigits) {
        if (twoHexDigits == null || twoHexDigits.length() != 2) {
            throw new IllegalArgumentException("URLDecoder: Illegal hex characters : \"" + twoHexDigits + "\"");
        }
        return Utils.hexCharsToByte(twoHexDigits.charAt(0), twoHexDigits.charAt(1));
    }

    public static byte hexCharsToByte(char c1, char c2) {
        byte result;
        switch (c1) {
            case '0': {
                result = 0;
                break;
            }
            case '1': {
                result = 16;
                break;
            }
            case '2': {
                result = 32;
                break;
            }
            case '3': {
                result = 48;
                break;
            }
            case '4': {
                result = 64;
                break;
            }
            case '5': {
                result = 80;
                break;
            }
            case '6': {
                result = 96;
                break;
            }
            case '7': {
                result = 112;
                break;
            }
            case '8': {
                result = -128;
                break;
            }
            case '9': {
                result = -112;
                break;
            }
            case 'a': {
                result = -96;
                break;
            }
            case 'b': {
                result = -80;
                break;
            }
            case 'c': {
                result = -64;
                break;
            }
            case 'd': {
                result = -48;
                break;
            }
            case 'e': {
                result = -32;
                break;
            }
            case 'f': {
                result = -16;
                break;
            }
            case 'A': {
                result = -96;
                break;
            }
            case 'B': {
                result = -80;
                break;
            }
            case 'C': {
                result = -64;
                break;
            }
            case 'D': {
                result = -48;
                break;
            }
            case 'E': {
                result = -32;
                break;
            }
            case 'F': {
                result = -16;
                break;
            }
            default: {
                throw new IllegalArgumentException("URLDecoder: Illegal hex characters (char 1): '" + c1 + "'");
            }
        }
        switch (c2) {
            case '0': {
                break;
            }
            case '1': {
                result = (byte)(result | 1);
                break;
            }
            case '2': {
                result = (byte)(result | 2);
                break;
            }
            case '3': {
                result = (byte)(result | 3);
                break;
            }
            case '4': {
                result = (byte)(result | 4);
                break;
            }
            case '5': {
                result = (byte)(result | 5);
                break;
            }
            case '6': {
                result = (byte)(result | 6);
                break;
            }
            case '7': {
                result = (byte)(result | 7);
                break;
            }
            case '8': {
                result = (byte)(result | 8);
                break;
            }
            case '9': {
                result = (byte)(result | 9);
                break;
            }
            case 'a': {
                result = (byte)(result | 0xA);
                break;
            }
            case 'b': {
                result = (byte)(result | 0xB);
                break;
            }
            case 'c': {
                result = (byte)(result | 0xC);
                break;
            }
            case 'd': {
                result = (byte)(result | 0xD);
                break;
            }
            case 'e': {
                result = (byte)(result | 0xE);
                break;
            }
            case 'f': {
                result = (byte)(result | 0xF);
                break;
            }
            case 'A': {
                result = (byte)(result | 0xA);
                break;
            }
            case 'B': {
                result = (byte)(result | 0xB);
                break;
            }
            case 'C': {
                result = (byte)(result | 0xC);
                break;
            }
            case 'D': {
                result = (byte)(result | 0xD);
                break;
            }
            case 'E': {
                result = (byte)(result | 0xE);
                break;
            }
            case 'F': {
                result = (byte)(result | 0xF);
                break;
            }
            default: {
                throw new IllegalArgumentException("URLDecoder: Illegal hex characters (char 2): '" + c2 + "'");
            }
        }
        return result;
    }

    public static String decodeApacheHTTPDLogValue(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        if (!input.contains("\\")) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char chr = input.charAt(i);
            if (chr == '\\') {
                chr = input.charAt(++i);
                switch (chr) {
                    case '\"': 
                    case '\\': {
                        sb.append(chr);
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'v': {
                        sb.append((char)Utils.hexCharsToByte('0', 'b'));
                        break;
                    }
                    case 'x': {
                        char chr1 = input.charAt(++i);
                        char chr2 = input.charAt(++i);
                        sb.append((char)Utils.hexCharsToByte(chr1, chr2));
                        break;
                    }
                    default: {
                        sb.append('\\').append(chr);
                        break;
                    }
                }
                continue;
            }
            sb.append(chr);
        }
        return sb.toString();
    }
}

