/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.geoip;

import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;

public abstract class AbstractGeoIPDissector
extends Dissector {
    static final String INPUT_TYPE = "IP";
    String databaseFileName;
    protected DatabaseReader reader;

    public AbstractGeoIPDissector() {
    }

    public AbstractGeoIPDissector(String databaseFileName) {
        this.databaseFileName = databaseFileName;
    }

    public String getInputType() {
        return INPUT_TYPE;
    }

    public boolean initializeFromSettingsParameter(String settings) {
        this.databaseFileName = settings;
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
        newInstance.initializeFromSettingsParameter(this.databaseFileName);
    }

    public void prepareForRun() throws InvalidDissectorException {
        try {
            this.reader = new DatabaseReader.Builder(this.openDatabaseFile(this.databaseFileName)).fileMode(Reader.FileMode.MEMORY).withCache((NodeCache)new CHMCache()).build();
        }
        catch (IOException e) {
            throw new InvalidDissectorException(((Object)((Object)this)).getClass().getCanonicalName() + ":" + e.getMessage());
        }
    }

    protected InputStream openDatabaseFile(String filename) throws FileNotFoundException {
        return new FileInputStream(filename);
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        InetAddress ipAddress;
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue().getString();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        try {
            ipAddress = InetAddress.getByName(fieldValue);
            if (ipAddress == null) {
                return;
            }
        }
        catch (UnknownHostException e) {
            return;
        }
        this.dissect(parsable, inputname, ipAddress);
    }

    abstract void dissect(Parsable<?> var1, String var2, InetAddress var3) throws DissectionFailure;
}

