/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.ANTLRErrorListener;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.CharStreams;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.CodePointCharStream;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.Parser;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.RecognitionException;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.Recognizer;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.atn.ATNConfigSet;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.dfa.DFA;
import nl.basjes.parse.httpdlog.shaded.org.antlr.v4.runtime.tree.ParseTreeWalker;
import nl.basjes.parse.strftime.StrfTimeBaseListener;
import nl.basjes.parse.strftime.StrfTimeLexer;
import nl.basjes.parse.strftime.StrfTimeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StrfTimeToDateTimeFormatter
extends StrfTimeBaseListener
implements ANTLRErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(StrfTimeToDateTimeFormatter.class);
    private static final WeekFields LOCAL_WEEK_FIELDS = WeekFields.of(Locale.getDefault());
    private String strfformat;
    private DateTimeFormatterBuilder builder;
    private ZoneId defaultZone;
    private boolean zoneWasSpecified = false;
    private boolean syntaxError = false;
    private static final Map<Long, String> AMPM_LOWER_CASE_MAPPING = new HashMap<Long, String>();

    public static DateTimeFormatter convert(String strfformat) {
        return StrfTimeToDateTimeFormatter.convert(strfformat, ZoneOffset.UTC);
    }

    public static DateTimeFormatter convert(String strfformat, ZoneId defaultZone) {
        CodePointCharStream input = CharStreams.fromString(strfformat);
        StrfTimeLexer lexer = new StrfTimeLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        StrfTimeParser parser = new StrfTimeParser(tokens);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        ParseTreeWalker walker = new ParseTreeWalker();
        StrfTimeToDateTimeFormatter converter = new StrfTimeToDateTimeFormatter(strfformat, defaultZone);
        lexer.addErrorListener(converter);
        parser.addErrorListener(converter);
        StrfTimeParser.PatternContext pattern = parser.pattern();
        walker.walk(converter, pattern);
        if (converter.hasSyntaxError()) {
            return null;
        }
        return converter.build();
    }

    private StrfTimeToDateTimeFormatter(String inputStrfformat, ZoneId newDefaultZone) {
        this.strfformat = inputStrfformat;
        this.defaultZone = newDefaultZone;
        this.builder = new DateTimeFormatterBuilder().parseCaseInsensitive();
    }

    public DateTimeFormatter build() {
        DateTimeFormatter dateTimeFormatter = this.builder.toFormatter();
        if (!this.zoneWasSpecified) {
            dateTimeFormatter = dateTimeFormatter.withZone(this.defaultZone);
            LOG.warn("The timestamp format \"{}\" does NOT contain a timezone so we assume \"{}\".", (Object)this.strfformat, (Object)this.defaultZone.getDisplayName(TextStyle.SHORT, Locale.ENGLISH));
        }
        return dateTimeFormatter;
    }

    public boolean hasSyntaxError() {
        return this.syntaxError;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object o, int i, int i1, String s, RecognitionException e) {
        this.syntaxError = true;
    }

    @Override
    public void reportAmbiguity(Parser parser, DFA dfa, int i, int i1, boolean b, BitSet bitSet, ATNConfigSet atnConfigSet) {
    }

    @Override
    public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitSet, ATNConfigSet atnConfigSet) {
    }

    @Override
    public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atnConfigSet) {
    }

    @Override
    public void enterMsecFrac(StrfTimeParser.MsecFracContext ctx) {
        this.builder.appendValue(ChronoField.MILLI_OF_SECOND, 3);
    }

    @Override
    public void enterUsecFrac(StrfTimeParser.UsecFracContext ctx) {
        this.builder.appendValue(ChronoField.MICRO_OF_SECOND, 6);
    }

    @Override
    public void enterText(StrfTimeParser.TextContext ctx) {
        this.builder.appendLiteral(ctx.getText());
    }

    @Override
    public void enterTab(StrfTimeParser.TabContext ctx) {
        this.builder.appendLiteral('\t');
    }

    @Override
    public void enterPercent(StrfTimeParser.PercentContext ctx) {
        this.builder.appendLiteral('%');
    }

    @Override
    public void enterNewline(StrfTimeParser.NewlineContext ctx) {
        this.builder.appendLiteral('\n');
    }

    @Override
    public void enterPa(StrfTimeParser.PaContext ctx) {
        this.builder.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.SHORT);
    }

    @Override
    public void enterPA(StrfTimeParser.PAContext ctx) {
        this.builder.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.FULL);
    }

    @Override
    public void enterPb(StrfTimeParser.PbContext ctx) {
        this.builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT);
    }

    @Override
    public void enterPB(StrfTimeParser.PBContext ctx) {
        this.builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.FULL);
    }

    @Override
    public void enterPc(StrfTimeParser.PcContext ctx) {
        throw new UnsupportedStrfField("%c   The preferred date and time representation for the current locale.");
    }

    @Override
    public void enterPC(StrfTimeParser.PCContext ctx) {
        throw new UnsupportedStrfField("%C   The century number (year/100) as a 2-digit integer.");
    }

    @Override
    public void enterPd(StrfTimeParser.PdContext ctx) {
        this.builder.appendValue(ChronoField.DAY_OF_MONTH, 2);
    }

    @Override
    public void enterPD(StrfTimeParser.PDContext ctx) {
        this.builder.appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('/').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('/').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, 2000);
    }

    @Override
    public void enterPe(StrfTimeParser.PeContext ctx) {
        this.builder.padNext(2, ' ').appendValue(ChronoField.DAY_OF_MONTH);
    }

    @Override
    public void enterPF(StrfTimeParser.PFContext ctx) {
        this.builder.appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2);
    }

    @Override
    public void enterPG(StrfTimeParser.PGContext ctx) {
        this.builder.appendValue(LOCAL_WEEK_FIELDS.weekBasedYear(), 4);
    }

    @Override
    public void enterPg(StrfTimeParser.PgContext ctx) {
        this.builder.appendValueReduced(LOCAL_WEEK_FIELDS.weekBasedYear(), 2, 2, 2000);
    }

    @Override
    public void enterPH(StrfTimeParser.PHContext ctx) {
        this.builder.appendValue(ChronoField.CLOCK_HOUR_OF_DAY, 2);
    }

    @Override
    public void enterPI(StrfTimeParser.PIContext ctx) {
        this.builder.appendValue(ChronoField.CLOCK_HOUR_OF_AMPM, 2);
    }

    @Override
    public void enterPj(StrfTimeParser.PjContext ctx) {
        this.builder.appendValue(ChronoField.DAY_OF_YEAR, 3);
    }

    @Override
    public void enterPk(StrfTimeParser.PkContext ctx) {
        this.builder.padNext(2, ' ').appendValue(ChronoField.CLOCK_HOUR_OF_DAY);
    }

    @Override
    public void enterPl(StrfTimeParser.PlContext ctx) {
        this.builder.padNext(2, ' ').appendValue(ChronoField.CLOCK_HOUR_OF_AMPM);
    }

    @Override
    public void enterPm(StrfTimeParser.PmContext ctx) {
        this.builder.appendValue(ChronoField.MONTH_OF_YEAR, 2);
    }

    @Override
    public void enterPM(StrfTimeParser.PMContext ctx) {
        this.builder.appendValue(ChronoField.MINUTE_OF_HOUR, 2);
    }

    @Override
    public void enterPp(StrfTimeParser.PpContext ctx) {
        this.builder.appendText((TemporalField)ChronoField.AMPM_OF_DAY, TextStyle.SHORT);
    }

    @Override
    public void enterPP(StrfTimeParser.PPContext ctx) {
        this.builder.appendText((TemporalField)ChronoField.AMPM_OF_DAY, AMPM_LOWER_CASE_MAPPING);
    }

    @Override
    public void enterPr(StrfTimeParser.PrContext ctx) {
        this.builder.appendValue(ChronoField.CLOCK_HOUR_OF_AMPM, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendText((TemporalField)ChronoField.AMPM_OF_DAY, TextStyle.SHORT);
    }

    @Override
    public void enterPR(StrfTimeParser.PRContext ctx) {
        this.builder.appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2);
    }

    @Override
    public void enterPs(StrfTimeParser.PsContext ctx) {
        this.builder.appendValue(ChronoField.INSTANT_SECONDS, 1, 19, SignStyle.NEVER);
    }

    @Override
    public void enterPS(StrfTimeParser.PSContext ctx) {
        this.builder.appendValue(ChronoField.SECOND_OF_MINUTE, 2);
    }

    @Override
    public void enterPT(StrfTimeParser.PTContext ctx) {
        this.builder.appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2);
    }

    @Override
    public void enterPu(StrfTimeParser.PuContext ctx) {
        this.builder.appendValue(WeekFields.ISO.dayOfWeek(), 1);
    }

    @Override
    public void enterPU(StrfTimeParser.PUContext ctx) {
        throw new UnsupportedStrfField("%U The week number of the current year ... ");
    }

    @Override
    public void enterPV(StrfTimeParser.PVContext ctx) {
        this.builder.appendValue(WeekFields.ISO.weekOfYear());
    }

    @Override
    public void enterPw(StrfTimeParser.PwContext ctx) {
        throw new UnsupportedStrfField("%w   The day of the week as a decimal, range 0 to 6, Sunday being 0. See also %u.");
    }

    @Override
    public void enterPW(StrfTimeParser.PWContext ctx) {
        this.builder.appendValue(WeekFields.ISO.weekOfYear(), 2);
    }

    @Override
    public void enterPx(StrfTimeParser.PxContext ctx) {
        throw new UnsupportedStrfField("%x   The preferred date representation for the current locale without the time.");
    }

    @Override
    public void enterPX(StrfTimeParser.PXContext ctx) {
        throw new UnsupportedStrfField("%X   The preferred time representation for the current locale without the date.");
    }

    @Override
    public void enterPy(StrfTimeParser.PyContext ctx) {
        this.builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, 2000);
    }

    @Override
    public void enterPY(StrfTimeParser.PYContext ctx) {
        this.builder.appendValue(ChronoField.YEAR, 4);
    }

    @Override
    public void enterPz(StrfTimeParser.PzContext ctx) {
        this.builder.appendOffset("+HHMM", "+0000");
        this.zoneWasSpecified = true;
    }

    @Override
    public void enterPZ(StrfTimeParser.PZContext ctx) {
        this.builder.appendZoneText(TextStyle.SHORT);
        this.zoneWasSpecified = true;
    }

    @Override
    public void enterPplus(StrfTimeParser.PplusContext ctx) {
        throw new UnsupportedStrfField("%p   The date and time in date(1) format.");
    }

    static {
        AMPM_LOWER_CASE_MAPPING.put(0L, "am");
        AMPM_LOWER_CASE_MAPPING.put(1L, "pm");
    }

    public static class UnsupportedStrfField
    extends RuntimeException {
        public UnsupportedStrfField(String s) {
            super("The field '" + s + "' cannot be converted towards a DateTimeFormatter field.");
        }
    }
}

