/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.Utils;

public class RequestCookieListDissector
extends Dissector {
    private static final String INPUT_TYPE = "HTTP.COOKIES";
    private final Set<String> requestedCookies = new HashSet<String>(16);
    private boolean wantAllCookies = false;
    private final Pattern fieldSeparatorPattern = Pattern.compile("; ");

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.COOKIE:*");
        return result;
    }

    public boolean initializeFromSettingsParameter(String settings) {
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        this.requestedCookies.add(outputname.substring(inputname.length() + 1));
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() {
        this.wantAllCookies = this.requestedCookies.contains("*");
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        String[] allValues;
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        for (String value : allValues = this.fieldSeparatorPattern.split(fieldValue)) {
            String theName;
            int equalPos = value.indexOf(61);
            if (equalPos == -1) {
                if ("".equals(value)) continue;
                theName = value.trim().toLowerCase();
                if (!this.wantAllCookies && !this.requestedCookies.contains(theName)) continue;
                parsable.addDissection(inputname, this.getDissectionType(inputname, theName), theName, "");
                continue;
            }
            theName = value.substring(0, equalPos).trim().toLowerCase();
            if (!this.wantAllCookies && !this.requestedCookies.contains(theName)) continue;
            String theValue = value.substring(equalPos + 1, value.length()).trim();
            try {
                parsable.addDissection(inputname, this.getDissectionType(inputname, theName), theName, Utils.resilientUrlDecode(theValue));
            }
            catch (IllegalArgumentException e) {
                throw new DissectionFailure(e.getMessage());
            }
        }
    }

    public String getDissectionType(String basename, String name) {
        return "HTTP.COOKIE";
    }
}

