/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.dissectors.http;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;

public class ResponseSetCookieListDissector
extends Dissector {
    private static final String INPUT_TYPE = "HTTP.SETCOOKIES";
    private final Set<String> requestedCookies = new HashSet<String>(16);
    private boolean wantAllCookies = false;
    private final int minimalExpiresLength = "expires=XXXXXXX".length();
    private static final String SPLIT_BY = ", ";

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.SETCOOKIE:*");
        return result;
    }

    public boolean initializeFromSettingsParameter(String settings) {
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        this.requestedCookies.add(outputname.substring(inputname.length() + 1));
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() {
        this.wantAllCookies = this.requestedCookies.contains("*");
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        String[] parts = fieldValue.split(SPLIT_BY);
        String previous = "";
        for (String part : parts) {
            int expiresIndex = part.toLowerCase().indexOf("expires=");
            if (expiresIndex != -1 && part.length() - this.minimalExpiresLength < expiresIndex) {
                previous = part;
                continue;
            }
            String value = part;
            if (!previous.isEmpty()) {
                value = previous + SPLIT_BY + part;
                previous = "";
            }
            List<HttpCookie> cookies = HttpCookie.parse(value);
            for (HttpCookie cookie : cookies) {
                cookie.setVersion(1);
                String cookieName = cookie.getName().toLowerCase();
                if (!this.wantAllCookies && !this.requestedCookies.contains(cookieName)) continue;
                parsable.addDissection(inputname, this.getDissectionType(inputname, cookieName), cookieName, value);
            }
        }
    }

    public String getDissectionType(String basename, String name) {
        return "HTTP.SETCOOKIE";
    }
}

