/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.http.disectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Disector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;

public class HttpFirstLineDisector
extends Disector {
    private final Pattern firstlineSplitter = Pattern.compile("^(OPTIONS|GET|HEAD|POST|PUT|DELETE|TRACE|CONNECT) (.*) (HTTP)/(.*)$");
    private static final String HTTP_FIRSTLINE = "HTTP.FIRSTLINE";
    private final Set<String> requestedParameters = new HashSet<String>(16);

    public String getInputType() {
        return HTTP_FIRSTLINE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.METHOD:method");
        result.add("HTTP.URI:uri");
        result.add("HTTP.PROTOCOL:protocol");
        result.add("HTTP.PROTOCOL.VERSION:protocol.version");
        return result;
    }

    public void disect(Parsable<?> parsable, String inputname) {
        ParsedField field = parsable.getParsableField(HTTP_FIRSTLINE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        Matcher matcher = this.firstlineSplitter.matcher(fieldValue);
        boolean matches = matcher.find();
        if (matches && matcher.groupCount() == 4) {
            this.outputDisection(parsable, inputname, "HTTP.METHOD", "method", matcher, 1);
            this.outputDisection(parsable, inputname, "HTTP.URI", "uri", matcher, 2);
            this.outputDisection(parsable, inputname, "HTTP.PROTOCOL", "protocol", matcher, 3);
            this.outputDisection(parsable, inputname, "HTTP.PROTOCOL.VERSION", "protocol.version", matcher, 4);
        }
    }

    private void outputDisection(Parsable<?> parsable, String inputname, String type, String name, Matcher matcher, int offset) {
        if (this.requestedParameters.contains(name)) {
            parsable.addDisection(inputname, type, name, matcher.group(offset));
        }
    }

    protected void initializeNewInstance(Disector newInstance) {
    }

    public EnumSet<Casts> prepareForDisect(String inputname, String outputname) {
        this.requestedParameters.add(outputname.substring(inputname.length() + 1));
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() {
    }
}

