/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.hadoop.input;

import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class ParsedRecord
extends MapWritable {
    private MapWritable LongValues;
    private MapWritable DoubleValues;
    public static final Text STRING = new Text("String");
    public static final Text LONG = new Text("Long");
    public static final Text DOUBLE = new Text("Double");
    private Text nameText = new Text();

    public ParsedRecord() {
        this.LongValues = new MapWritable();
        this.DoubleValues = new MapWritable();
        super.put((Writable)LONG, (Writable)this.LongValues);
        super.put((Writable)DOUBLE, (Writable)this.DoubleValues);
    }

    public void clear() {
        super.clear();
        this.LongValues.clear();
        this.DoubleValues.clear();
    }

    public void set(String name, String value) {
        if (value != null) {
            this.put((Writable)new Text(name), (Writable)new Text(value));
        }
    }

    public void set(String name, Long value) {
        if (value != null) {
            this.LongValues.put((Writable)new Text(name), (Writable)new LongWritable(value.longValue()));
        }
    }

    public void set(String name, Double value) {
        if (value != null) {
            this.DoubleValues.put((Writable)new Text(name), (Writable)new DoubleWritable(value.doubleValue()));
        }
    }

    public String getString(String name) {
        this.nameText.set(name);
        Text value = (Text)this.get(this.nameText);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Long getLong(String name) {
        this.nameText.set(name);
        LongWritable value = (LongWritable)this.LongValues.get((Object)this.nameText);
        if (value == null) {
            return null;
        }
        return value.get();
    }

    public Double getDouble(String name) {
        this.nameText.set(name);
        DoubleWritable value = (DoubleWritable)this.DoubleValues.get((Object)this.nameText);
        if (value == null) {
            return null;
        }
        return value.get();
    }
}

